/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.util.Collection;
import java.util.Iterator;
import org.simantics.utils.datastructures.Converter;
import org.simantics.utils.datastructures.IteratorAdapter;

public class CollectionAdapter<Domain, Range, C extends Collection<Domain>>
implements Collection<Range> {
    protected Converter<Domain, Range> converter;
    protected C collection;

    public CollectionAdapter(Converter<Domain, Range> converter, C collection) {
        this.converter = converter;
        this.collection = collection;
    }

    @Override
    public boolean add(Range e) {
        return this.collection.add(this.converter.convertFrom(e));
    }

    @Override
    public boolean addAll(Collection<? extends Range> c) {
        return this.collection.addAll(new CollectionAdapter<Range, Domain, Collection<? extends Range>>(CollectionAdapter.inverseConverter(this.converter), c));
    }

    @Override
    public void clear() {
        this.collection.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.collection.contains(this.converter.convertFrom(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public Iterator<Range> iterator() {
        return new IteratorAdapter(this.converter, this.collection.iterator());
    }

    @Override
    public boolean remove(Object o) {
        return this.collection.remove(this.converter.convertFrom(o));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = false;
        for (Object o : c) {
            removed |= this.remove(o);
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.collection.retainAll(new CollectionAdapter(CollectionAdapter.inverseConverter(this.converter), c));
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public Object[] toArray() {
        Object[] ret = new Object[this.collection.size()];
        int i = 0;
        for (Object d : this.collection) {
            ret[i++] = this.converter.convertTo(d);
        }
        return ret;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    public static <D, R> Converter<R, D> inverseConverter(final Converter<D, R> converter) {
        return new Converter<R, D>(){

            @Override
            public R convertFrom(D rangeElement) {
                return converter.convertTo(rangeElement);
            }

            @Override
            public D convertTo(R domainElement) {
                return converter.convertFrom(domainElement);
            }
        };
    }
}

