/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.threads;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.simantics.utils.threads.IThreadWorkQueue;

public class AWTThread
extends AbstractExecutorService
implements IThreadWorkQueue,
Executor {
    public static AWTThread INSTANCE = new AWTThread();

    public static IThreadWorkQueue getThreadAccess() {
        return INSTANCE;
    }

    @Override
    public Thread asyncExec(Runnable runnable) {
        EventQueue.invokeLater(runnable);
        return null;
    }

    @Override
    public boolean syncExec(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
            return true;
        }
        try {
            SwingUtilities.invokeAndWait(runnable);
            return true;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public boolean currentThreadAccess() {
        return EventQueue.isDispatchThread();
    }

    @Override
    public Thread getThread() {
        if (this.currentThreadAccess()) {
            return Thread.currentThread();
        }
        return null;
    }

    public String toString() {
        return "AWT Thread";
    }

    @Override
    public void execute(Runnable command) {
        EventQueue.invokeLater(command);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return null;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }
}

