/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.studio.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.request.Read;
import org.simantics.utils.FileUtils;

public class WorkspaceUtil {
    public static File ensureDirectoryExistence(File dir) throws IOException {
        if (dir.exists() && !dir.isDirectory()) {
            FileUtils.deleteAll((File)dir);
        }
        dir.mkdirs();
        if (!dir.exists() || !dir.isDirectory()) {
            throw new FileNotFoundException("Could not create directory '" + dir + "'. Out of disk space?");
        }
        return dir;
    }

    public static File getWorkspacePath(boolean escapeNames, String ... relativeSegments) {
        IPath finalPath = Platform.getLocation();
        int i = 0;
        while (i < relativeSegments.length) {
            finalPath = finalPath.append(escapeNames ? URIStringUtils.escapeURI((String)relativeSegments[i]) : relativeSegments[i]);
            ++i;
        }
        return finalPath.toFile();
    }

    public static File getExperimentDirectory(ReadGraph g, Resource experiment, boolean ensureExistence, String ... subdirs) throws DatabaseException, IOException {
        Resource model = (Resource)g.syncRequest((Read)new PossibleIndexRoot(experiment));
        if (model == null) {
            throw new ValidationException("Experiment '" + NameUtils.getSafeName((ReadGraph)g, (Resource)experiment) + "' is not part of any model. Has the experiment been removed already? Database may also be corrupted?");
        }
        String[] dirs = new String[3 + subdirs.length];
        dirs[0] = "fmi";
        dirs[1] = "model-" + model.getResourceId();
        dirs[2] = "experiment-" + experiment.getResourceId();
        System.arraycopy(subdirs, 0, dirs, 3, subdirs.length);
        File experimentPath = WorkspaceUtil.getWorkspacePath(false, dirs);
        WorkspaceUtil.ensureDirectoryExistence(experimentPath);
        return experimentPath;
    }
}

