/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.rpcexperiment;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.simantics.fmi.rpcexperiment.JavaProcess;

public class JavaConsoleProcess
extends JavaProcess {
    private String javaHome;
    private Class clazz;

    public JavaConsoleProcess(String javaHome, Class clazz) {
        this.javaHome = javaHome;
        if (this.javaHome == null) {
            this.javaHome = this.resolveJavaHome();
        }
        if (this.javaHome == null) {
            throw new RuntimeException("Cannot locate Java path");
        }
        this.clazz = clazz;
    }

    @Override
    protected Process startProcess() throws IOException {
        String javaBin = String.valueOf(this.javaHome) + File.separator + "bin" + File.separator + "java";
        String classpath = System.getProperty("java.class.path");
        String className = this.clazz.getCanonicalName();
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(javaBin);
        commands.add("-cp");
        commands.add(classpath);
        ProcessBuilder builder = new ProcessBuilder(javaBin, "-cp", classpath, className);
        Process process = builder.start();
        return process;
    }
}

