/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.ArrayAccessor;
import org.simantics.databoard.accessor.LongAccessor;
import org.simantics.databoard.accessor.MapAccessor;
import org.simantics.databoard.accessor.OptionalAccessor;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.UnionAccessor;
import org.simantics.databoard.accessor.VariantAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.ComponentReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.type.VariantType;
import org.simantics.databoard.util.DatatypeVisitorAdapter;

public class TGResourceUtil {
    public static final Datatype RESOURCE_TYPE = new LongType();
    Map<Datatype, Item> items = new HashMap<Datatype, Item>();
    int index = 0;

    static {
        TGResourceUtil.RESOURCE_TYPE.metadata.put("resource", "true");
    }

    public Item createItem(Datatype type) {
        Item item = new Item();
        item.index = this.index++;
        item.type = type;
        HasResVisitor v = new HasResVisitor();
        type.accept(v, item);
        if (v.hasRes || v.hasVariant) {
            GetRefsVisitor vv = new GetRefsVisitor();
            type.accept(vv, item);
        }
        return item;
    }

    public void findResources(Datatype type, byte[] value, final Collection<Long> result) throws AccessorConstructionException, AccessorException {
        LongAdapter la = new LongAdapter(){

            @Override
            public long adapt(long in) {
                result.add(in);
                return in;
            }
        };
        this.adaptValue(type, value, la);
    }

    public void findResources(Binding binding, Object value, final Collection<Long> result) throws AccessorConstructionException, AccessorException {
        LongAdapter la = new LongAdapter(){

            @Override
            public long adapt(long in) {
                result.add(in);
                return in;
            }
        };
        this.adaptValue(binding, value, la);
    }

    public Item addType(Datatype type) {
        Item i = this.items.get(type);
        if (i == null) {
            i = this.createItem(type);
            this.items.put(type, i);
        }
        return i;
    }

    public void adaptValue(Datatype type, byte[] value, LongAdapter adapter) throws AccessorException {
        Item i = this.addType(type);
        if (!i.mayHaveResource()) {
            return;
        }
        try {
            Object a = Accessors.getAccessor(value, type);
            this.adaptValue(i, (Accessor)a, adapter);
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    public void adaptValue(Binding binding, Object value, LongAdapter adapter) throws AccessorException {
        Item i = this.addType(binding.type());
        if (!i.mayHaveResource()) {
            return;
        }
        try {
            Object a = Accessors.getAccessor(binding, value);
            this.adaptValue(i, (Accessor)a, adapter);
        }
        catch (AccessorConstructionException e) {
            throw new AccessorException(e);
        }
    }

    void adaptValue(Item i, Accessor a, LongAdapter adapter) throws AccessorException, AccessorConstructionException {
        if (i.resources != null) {
            for (ChildReference r : i.resources) {
                this.adaptValue(a, r, adapter);
            }
        }
        if (i.variants != null) {
            for (ChildReference r : i.variants) {
                this.adaptValue(a, r, adapter);
            }
        }
    }

    void adaptValue(Accessor a, ChildReference r, LongAdapter adapter) throws AccessorException, AccessorConstructionException {
        Accessor x;
        long value;
        long newValue;
        if (a instanceof LongAccessor && (newValue = adapter.adapt(value = (x = (LongAccessor)a).getValue())) != value) {
            x.setValue(newValue);
        }
        if (a instanceof VariantAccessor) {
            x = (VariantAccessor)a;
            Item i = this.createItem(x.getContentType());
            this.adaptValue(i, (Accessor)x.getContentAccessor(), adapter);
        }
        if (a instanceof MapAccessor) {
            x = (MapAccessor)a;
            if (r instanceof IndexReference) {
                int n;
                Object keyBinding;
                IndexReference ir = (IndexReference)r;
                if (ir.index == 0) {
                    Object[] keys;
                    keyBinding = Bindings.getBinding(x.type().keyType);
                    Object valueBinding = Bindings.getBinding(x.type().valueType);
                    Object[] objectArray = keys = x.getKeys((Binding)keyBinding);
                    int n2 = keys.length;
                    n = 0;
                    while (n < n2) {
                        Object key = objectArray[n];
                        Object value2 = x.get((Binding)keyBinding, key, (Binding)valueBinding);
                        Object ka = Accessors.getAccessor(keyBinding, key);
                        this.adaptValue((Accessor)ka, r.childReference, adapter);
                        x.remove((Binding)keyBinding, key);
                        x.put((Binding)keyBinding, key, (Binding)valueBinding, value2);
                        ++n;
                    }
                }
                if (ir.index == 1) {
                    Object[] keys;
                    keyBinding = Bindings.getBinding(x.type().keyType);
                    Object[] objectArray = keys = x.getKeys((Binding)keyBinding);
                    n = keys.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Object key = objectArray[n3];
                        Object va = x.getValueAccessor((Binding)keyBinding, key);
                        this.adaptValue((Accessor)va, r.childReference, adapter);
                        ++n3;
                    }
                }
            }
        }
        if (a instanceof ArrayAccessor) {
            x = (ArrayAccessor)a;
            int len = x.size();
            int i = 0;
            while (i < len) {
                Object sa = x.getAccessor(i);
                this.adaptValue((Accessor)sa, r.childReference, adapter);
                ++i;
            }
        }
        if (a instanceof UnionAccessor) {
            x = (UnionAccessor)a;
            IndexReference ir = (IndexReference)r;
            if (x.getTag() == ir.index) {
                Object sa = x.getComponentAccessor();
                this.adaptValue((Accessor)sa, ir.childReference, adapter);
            }
        }
        if (a instanceof RecordAccessor) {
            x = (RecordAccessor)a;
            IndexReference ir = (IndexReference)r;
            Object sa = x.getFieldAccessor(ir.index);
            this.adaptValue((Accessor)sa, ir.childReference, adapter);
        }
        if (a instanceof OptionalAccessor && (x = (OptionalAccessor)a).hasValue()) {
            Object sa = x.getComponentAccessor();
            this.adaptValue((Accessor)sa, r.childReference, adapter);
        }
    }

    static class GetRefsVisitor
    extends DatatypeVisitorAdapter {
        Stack<ChildReference> stack = new Stack();

        GetRefsVisitor() {
        }

        @Override
        public void visit(ArrayType b, Object obj) {
            if (!this.visited.add(b)) {
                return;
            }
            ComponentReference r = new ComponentReference();
            this.stack.push(r);
            b.componentType.accept(this, obj);
            this.stack.pop();
        }

        @Override
        public void visit(LongType b, Object obj) {
            boolean isRes;
            String s = (String)b.metadata.get("unit");
            boolean bl = isRes = s != null && s.equals("resource");
            if (isRes) {
                Item item = (Item)obj;
                item.addResource(this.toRef());
            }
        }

        @Override
        public void visit(MapType b, Object obj) {
            if (!this.visited.add(b)) {
                return;
            }
            IndexReference r = new IndexReference(0);
            this.stack.push(r);
            b.keyType.accept(this, obj);
            this.stack.pop();
            r.index = 1;
            this.stack.push(r);
            b.valueType.accept(this, obj);
            this.stack.pop();
        }

        @Override
        public void visit(OptionalType b, Object obj) {
            if (!this.visited.add(b)) {
                return;
            }
            ComponentReference r = new ComponentReference();
            this.stack.push(r);
            b.componentType.accept(this, obj);
            this.stack.pop();
        }

        @Override
        public void visit(RecordType b, Object obj) {
            if (!this.visited.add(b)) {
                return;
            }
            IndexReference r = new IndexReference(0);
            this.stack.push(r);
            int i = 0;
            while (i < b.getComponentCount()) {
                r.index = i;
                b.getComponent((int)i).type.accept(this, obj);
                ++i;
            }
            this.stack.pop();
        }

        @Override
        public void visit(UnionType b, Object obj) {
            if (!this.visited.add(b)) {
                return;
            }
            IndexReference r = new IndexReference(0);
            this.stack.push(r);
            int i = 0;
            while (i < b.getComponentCount()) {
                r.index = i;
                b.getComponent((int)i).type.accept(this, obj);
                ++i;
            }
            this.stack.pop();
        }

        @Override
        public void visit(VariantType b, Object obj) {
            Item item = (Item)obj;
            item.addVariant(this.toRef());
        }

        ChildReference toRef() {
            return ChildReference.compile(this.stack);
        }
    }

    static class HasResVisitor
    extends DatatypeVisitorAdapter {
        boolean hasRes = false;
        boolean hasVariant = false;

        HasResVisitor() {
        }

        @Override
        public void visit(VariantType b, Object obj) {
            this.hasVariant = true;
        }

        @Override
        public void visit(LongType b, Object obj) {
            String s = (String)b.metadata.get("unit");
            this.hasRes |= s != null && s.equals("resource");
        }
    }

    public static class Item {
        public Datatype type;
        public int index;
        List<ChildReference> variants;
        List<ChildReference> resources;

        public boolean mayHaveResource() {
            return this.variants != null && !this.variants.isEmpty() || this.resources != null && !this.resources.isEmpty();
        }

        void addVariant(ChildReference ref) {
            if (this.variants == null) {
                this.variants = new ArrayList<ChildReference>();
            }
            this.variants.add(ref);
        }

        void addResource(ChildReference ref) {
            if (this.resources == null) {
                this.resources = new ArrayList<ChildReference>();
            }
            this.resources.add(ref);
        }
    }

    public static interface LongAdapter {
        public long adapt(long var1);
    }
}

