/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.store;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.graph.representation.Value;
import org.simantics.graph.store.IStore;
import org.simantics.graph.store.IndexMappingUtils;

public class ValueStore
implements IStore {
    public static Binding DatatypeBinding = Bindings.getBindingUnchecked(Datatype.class);
    public static Serializer DatatypeSerializer = Bindings.getSerializerUnchecked(DatatypeBinding);
    TIntObjectHashMap<Variant> byteValues = new TIntObjectHashMap();
    TIntObjectHashMap<Datatype> datatypeValues = new TIntObjectHashMap();
    TIntHashSet collisions = new TIntHashSet();
    private static final Binding DATATYPE_BINDING = Bindings.getBindingUnchecked(Datatype.class);

    @Override
    public void map(TIntIntHashMap map) {
        this.collisions = IndexMappingUtils.map(map, this.collisions);
        this.byteValues = IndexMappingUtils.map(map, this.byteValues, this.collisions);
        this.datatypeValues = IndexMappingUtils.map(map, this.datatypeValues, this.collisions);
    }

    public void setValue(int id, Variant value) {
        if (this.byteValues.put(id, value) != null) {
            this.collisions.add(id);
        }
    }

    public void setValue(int id, Datatype value) {
        this.datatypeValues.put(id, value);
    }

    public Variant getByteValue(int id) {
        return this.byteValues.get(id);
    }

    public Datatype getDatatypeValue(int id) {
        Variant bytes;
        Datatype datatype = this.datatypeValues.get(id);
        if (datatype == null && (bytes = this.byteValues.get(id)) != null) {
            try {
                return (Datatype)bytes.getValue(DATATYPE_BINDING);
            }
            catch (AdaptException e) {
                throw new RuntimeException(e);
            }
        }
        return datatype;
    }

    public Value[] toArray() {
        final ArrayList values = new ArrayList();
        this.byteValues.forEachEntry(new TIntObjectProcedure<Variant>(){

            @Override
            public boolean execute(int a, Variant b) {
                values.add(new Value(a, b));
                return true;
            }
        });
        this.datatypeValues.forEachEntry(new TIntObjectProcedure<Datatype>(){
            Binding datatypeBinding = Bindings.getBindingUnchecked(Datatype.class);

            @Override
            public boolean execute(int a, Datatype b) {
                if (!ValueStore.this.byteValues.containsKey(a)) {
                    try {
                        if (b == null) {
                            System.out.println("Resource " + a + " has null Datatype value.");
                        } else {
                            values.add(new Value(a, new Variant(this.datatypeBinding, b)));
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return true;
            }
        });
        return values.toArray(new Value[values.size()]);
    }

    public void collectReferences(final boolean[] set) {
        TIntProcedure proc = new TIntProcedure(){

            @Override
            public boolean execute(int value) {
                set[value] = true;
                return true;
            }
        };
        this.byteValues.forEach(proc);
        this.datatypeValues.forEach(proc);
    }

    public TIntHashSet getCollisions() {
        this.datatypeValues.forEachKey(new TIntProcedure(){

            @Override
            public boolean execute(int value) {
                if (ValueStore.this.byteValues.containsKey(value)) {
                    ValueStore.this.collisions.add(value);
                }
                return true;
            }
        });
        return this.collisions;
    }
}

