/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.query;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.RuntimeAdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.graph.query.IGraph;
import org.simantics.graph.query.NoUniqueObjectException;
import org.simantics.graph.query.NoValueException;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.Paths;
import org.simantics.graph.query.Res;
import org.simantics.graph.store.GraphStore;
import org.simantics.graph.store.IdRes;
import org.simantics.graph.store.IdentityStore;
import org.simantics.graph.store.PathPattern;
import org.simantics.graph.store.StatementStore;

public class CompositeGraph
implements IGraph {
    ArrayList<GraphStore> fragments = new ArrayList();
    Paths paths;
    private static ResourceFunction<Datatype> getDatatype = new ResourceFunction<Datatype>(){

        @Override
        public Datatype execute(GraphStore fragment, int id) {
            return fragment.values.getDatatypeValue(id);
        }
    };
    private static ResourceFunction<Variant> getValue = new ResourceFunction<Variant>(){

        @Override
        public Variant execute(GraphStore fragment, int id) {
            return fragment.values.getByteValue(id);
        }
    };
    THashMap<Res, Datatype> datatypeCache = new THashMap();

    public CompositeGraph(Paths paths) {
        this.paths = paths;
    }

    public void addFragment(GraphStore fragment) {
        this.fragments.add(fragment);
    }

    public void undoAddFragment() {
        this.fragments.remove(this.fragments.size() - 1);
    }

    public void addFragments(Collection<GraphStore> fragments) {
        fragments.addAll(fragments);
    }

    protected void rawGetObjects(GraphStore fragment, int subject, Res predicate, Collection<Res> result) {
        int predicateId;
        if (predicate instanceof Path) {
            predicateId = fragment.identities.pathToId((Path)predicate);
            if (predicateId < 0) {
                return;
            }
        } else {
            IdRes idPredicate = (IdRes)predicate;
            if (idPredicate.fragment != fragment) {
                return;
            }
            predicateId = idPredicate.id;
        }
        TIntArrayList objects = fragment.statements.getObjects(subject, predicateId);
        fragment.addIdsToResult(objects, result);
    }

    private void rawGetObjects(Res subject, Res predicate, Collection<Res> result) {
        if (subject instanceof Path) {
            Path path = (Path)subject;
            for (GraphStore fragment : this.fragments) {
                int id = fragment.identities.pathToId(path);
                if (id < 0) continue;
                this.rawGetObjects(fragment, id, predicate, result);
            }
        } else {
            IdRes idRes = (IdRes)subject;
            this.rawGetObjects(idRes.fragment, idRes.id, predicate, result);
        }
    }

    public boolean hasRawObjects(Res subject, Path predicate) {
        ArrayList<Res> result = new ArrayList<Res>();
        this.rawGetObjects(subject, predicate, result);
        return !result.isEmpty();
    }

    @Override
    public Collection<Res> rawGetObjects(Res subject, Res predicate) {
        ArrayList<Res> result = new ArrayList<Res>();
        this.rawGetObjects(subject, predicate, result);
        return result;
    }

    @Override
    public Res singleRawObject(Res subject, Res predicate) throws NoUniqueObjectException {
        ArrayList<Res> result = new ArrayList<Res>(1);
        this.rawGetObjects(subject, predicate, result);
        if (result.size() != 1) {
            throw new NoUniqueObjectException("No unique objects (" + result.size() + ") for " + subject + " -> " + predicate);
        }
        return result.get(0);
    }

    @Override
    public Collection<Res> getTypes(Res subject) {
        THashSet<Res> result = new THashSet<Res>();
        this.rawGetObjects(subject, this.paths.InstanceOf, result);
        Res[] resArray = result.toArray(new Res[result.size()]);
        int n = resArray.length;
        int n2 = 0;
        while (n2 < n) {
            Res type = resArray[n2];
            this.collectSupertypes(type, result);
            ++n2;
        }
        return result;
    }

    public Collection<Res> getSupertypes(Res subject) {
        THashSet<Res> result = new THashSet<Res>();
        result.add(subject);
        this.collectSupertypes(subject, result);
        return result;
    }

    private void collectSupertypes(Res type, THashSet<Res> result) {
        for (Res supertype : this.rawGetObjects(type, this.paths.Inherits)) {
            if (!result.add(supertype)) continue;
            this.collectSupertypes(supertype, result);
        }
    }

    @Override
    public Collection<Res> getObjects(Res subject, Res predicate) {
        ArrayList<Res> result = new ArrayList<Res>();
        this.rawGetObjects(subject, predicate, result);
        for (Res type : this.getTypes(subject)) {
            for (Res assertion : this.rawGetObjects(type, this.paths.Asserts)) {
                Res pred = this.singleRawObject(assertion, this.paths.HasPredicate);
                if (!CompositeGraph.equals(pred, predicate)) continue;
                result.add(this.singleRawObject(assertion, this.paths.HasObject));
            }
        }
        return result;
    }

    public Collection<Res> getAssertedObjects(Res subject, Path predicate) {
        ArrayList<Res> result = new ArrayList<Res>();
        for (Res type : this.getSupertypes(subject)) {
            for (Res assertion : this.rawGetObjects(type, this.paths.Asserts)) {
                Res pred = this.singleRawObject(assertion, this.paths.HasPredicate);
                if (!CompositeGraph.equals(pred, predicate)) continue;
                result.add(this.singleRawObject(assertion, this.paths.HasObject));
            }
        }
        return result;
    }

    private static boolean equals(Res r1, Res r2) {
        return r1.equals(r2);
    }

    public void forEachFragmentContaining(Res resource, ResourceProcedure proc) {
        if (resource instanceof Path) {
            Path path = (Path)resource;
            for (GraphStore fragment : this.fragments) {
                int id = fragment.identities.pathToId(path);
                if (id < 0) continue;
                proc.execute(fragment, id);
            }
        } else {
            IdRes res = (IdRes)resource;
            proc.execute(res.fragment, res.id);
        }
    }

    public <T> T apply(Res resource, ResourceFunction<T> func) {
        if (resource instanceof Path) {
            Path path = (Path)resource;
            for (GraphStore fragment : this.fragments) {
                T value;
                int id = fragment.identities.pathToId(path);
                if (id < 0 || (value = func.execute(fragment, id)) == null) continue;
                return value;
            }
            return null;
        }
        IdRes res = (IdRes)resource;
        return func.execute(res.fragment, res.id);
    }

    @Override
    public Datatype getDatatype(Res resource) {
        Iterator<Res> iterator = this.getObjects(resource, this.paths.HasDatatype).iterator();
        if (iterator.hasNext()) {
            Res dt = iterator.next();
            Datatype type = this.datatypeCache.get(dt);
            if (type == null) {
                type = this.apply(dt, getDatatype);
                this.datatypeCache.put(dt, type);
            }
            return type;
        }
        return null;
    }

    @Override
    public Datatype getAssertedDatatype(Res resource) {
        Iterator<Res> iterator = this.getAssertedObjects(resource, this.paths.HasDatatype).iterator();
        if (iterator.hasNext()) {
            Res dt = iterator.next();
            Datatype type = this.datatypeCache.get(dt);
            if (type == null) {
                type = this.apply(dt, getDatatype);
                this.datatypeCache.put(dt, type);
            }
            return type;
        }
        return null;
    }

    @Override
    public Variant getValue(Res resource) {
        return this.apply(resource, getValue);
    }

    @Override
    public Object getValue(Res resource, Binding binding) throws NoValueException {
        Variant value = this.getValue(resource);
        if (value == null) {
            throw new NoValueException();
        }
        try {
            return value.getValue(binding);
        }
        catch (AdaptException e) {
            throw new RuntimeAdaptException(e);
        }
    }

    @Override
    public void setValue(Res resource, Object value, Binding binding) {
        final Variant variant = new Variant(binding, value);
        this.apply(resource, new ResourceFunction<Object>(){

            @Override
            public Object execute(GraphStore fragment, int id) {
                fragment.values.setValue(id, variant);
                return null;
            }
        });
    }

    public int countOccurences(Res resource) {
        if (resource instanceof IdRes) {
            return 1;
        }
        if (resource instanceof Path) {
            Path path = (Path)resource;
            int count = 0;
            for (GraphStore fragment : this.fragments) {
                if (!fragment.identities.contains(path)) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    private void collectSubtypes(THashSet<Res> types, Res type) {
        if (types.add(type)) {
            for (Res subtype : this.rawGetObjects(type, this.paths.SupertypeOf)) {
                this.collectSubtypes(types, subtype);
            }
        }
    }

    @Override
    public Collection<Res> getInstances(Res supertype) {
        THashSet<Res> types = new THashSet<Res>();
        this.collectSubtypes(types, supertype);
        ArrayList<Res> result = new ArrayList<Res>();
        for (GraphStore fragment : this.fragments) {
            int instanceOfId;
            IdentityStore identities = fragment.identities;
            StatementStore statements = fragment.statements;
            TIntHashSet ids = new TIntHashSet(types.size());
            for (Res type : types) {
                if (type instanceof Path) {
                    int id = identities.pathToId((Path)type);
                    if (id < 0) continue;
                    ids.add(id);
                    continue;
                }
                IdRes idRes = (IdRes)type;
                if (idRes.fragment != fragment) continue;
                ids.add(idRes.id);
            }
            if (ids.isEmpty() || (instanceOfId = identities.pathToId(this.paths.InstanceOf)) < 0) continue;
            int resourceCount = identities.getResourceCount();
            int i = 0;
            while (i < resourceCount) {
                int[] nArray = statements.getObjects(i, instanceOfId).toArray();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int typeId = nArray[n2];
                    if (ids.contains(typeId)) {
                        result.add(fragment.idToRes(i));
                        break;
                    }
                    ++n2;
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public Collection<Res> getChildren(Res res) {
        if (res instanceof Path) {
            THashSet<Res> result = new THashSet<Res>();
            for (GraphStore store : this.fragments) {
                IdentityStore ids = store.identities;
                int id = ids.pathToId((Path)res);
                if (id < 0) continue;
                int[] nArray = ids.getChildren(id);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int child = nArray[n2];
                    result.add(store.idToRes(child));
                    ++n2;
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    public Collection<Path> searchByPattern(String pattern) {
        THashSet<Path> result = new THashSet<Path>();
        PathPattern pathPattern = PathPattern.compile(pattern);
        for (GraphStore store : this.fragments) {
            pathPattern.search(store.identities, result);
        }
        return result;
    }

    @Override
    public Paths getPaths() {
        return this.paths;
    }

    static interface ResourceFunction<T> {
        public T execute(GraphStore var1, int var2);
    }

    static interface ResourceProcedure {
        public void execute(GraphStore var1, int var2);
    }
}

