/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Files;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.RuntimeAdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.util.RandomValue;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;

public class Bean
implements Cloneable,
Comparable<Bean> {
    protected transient RecordBinding binding;

    protected Bean() {
        this.binding = (RecordBinding)Bindings.getBindingUnchecked(this.getClass());
    }

    protected Bean(Binding binding) {
        this.binding = (RecordBinding)binding;
    }

    public RecordBinding getBinding() {
        return this.binding;
    }

    public void readFrom(Bean other) {
        this.binding.readFromUnchecked(other.binding, other, this);
    }

    public void readAvailableFields(Bean other) {
        if (!(other.binding instanceof RecordBinding)) {
            return;
        }
        Component[] components = this.binding.type().getComponents();
        int i = 0;
        while (i < components.length) {
            Component c = components[i];
            int ix = other.binding.getComponentIndex(c.name);
            if (ix >= 0) {
                try {
                    Object value = other.binding.getComponent(other, ix);
                    Object value2 = Bindings.adapt(value, other.binding.getComponentBinding(ix), this.binding.getComponentBinding(i));
                    this.binding.setComponent(this, i, value2);
                }
                catch (AdaptException e) {
                    throw new RuntimeException(e);
                }
                catch (BindingException e) {
                    throw new RuntimeBindingException(e);
                }
            }
            ++i;
        }
    }

    public void init() {
        try {
            int i = 0;
            while (i < this.binding.getComponentCount()) {
                Object v = this.binding.getComponent(this, i);
                Binding cb = this.binding.componentBindings[i];
                if (v == null && !(cb instanceof OptionalBinding)) {
                    v = cb.createDefault();
                    this.binding.setComponent(this, i, v);
                }
                ++i;
            }
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public void setToDefault() {
        int i = 0;
        while (i < this.binding.componentBindings.length) {
            Binding cb = this.binding.componentBindings[i];
            try {
                this.binding.setComponent(this, i, cb.createDefault());
            }
            catch (BindingException bindingException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void setToRandom(Random random) {
        RandomValue rv = new RandomValue(random);
        int i = 0;
        while (i < this.binding.componentBindings.length) {
            Binding cb = this.binding.componentBindings[i];
            try {
                this.binding.setComponent(this, i, cb.createRandom(rv));
            }
            catch (BindingException bindingException) {
                // empty catch block
            }
            ++i;
        }
    }

    public int hashCode() {
        try {
            return this.binding.hashValue(this);
        }
        catch (BindingException e) {
            return -1;
        }
    }

    public Bean clone() {
        try {
            return (Bean)this.binding.clone(this);
        }
        catch (AdaptException e) {
            throw new RuntimeAdaptException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Bean)) {
            return false;
        }
        Bean other = (Bean)obj;
        if (other.binding == this.binding) {
            return this.binding.equals(this, obj);
        }
        try {
            return Bindings.equals(this.binding, this, other.binding, other);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public boolean equalContents(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Bean other = (Bean)obj;
        if (other.binding == this.binding) {
            return this.binding.equals(this, obj);
        }
        try {
            return Bindings.equals(this.binding, this, other.binding, other);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    @Override
    public int compareTo(Bean o) {
        if (o == null) {
            return -1;
        }
        return this.binding.compare(this, o);
    }

    public String toString() {
        try {
            return this.binding.toString(this);
        }
        catch (BindingException e) {
            return e.getMessage();
        }
    }

    public void print(Appendable out) throws IOException {
        try {
            DataValueRepository rep = new DataValueRepository();
            this.binding.printValue(this, out, rep, false);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public String print() throws IOException {
        try {
            StringBuilder sb = new StringBuilder();
            DataValueRepository rep = new DataValueRepository();
            this.binding.printValue(this, sb, rep, false);
            return sb.toString();
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public String printLine() throws IOException {
        try {
            StringBuilder sb = new StringBuilder();
            DataValueRepository rep = new DataValueRepository();
            this.binding.printValue(this, sb, rep, true);
            return sb.toString();
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public void parse(String str) throws DataTypeSyntaxError {
        try {
            DataValueRepository rep = new DataValueRepository();
            Object v = this.binding.parseValue(str, rep);
            this.init();
            this.binding.readFrom(this.binding, v, this);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        try {
            Serializer s = Bindings.getSerializer(this.binding);
            s.deserialize(in, (Object)this);
        }
        catch (SerializerConstructionException e) {
            throw new IOException(e);
        }
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        try {
            Serializer s = Bindings.getSerializer(this.binding);
            s.serialize(out, (Object)this);
        }
        catch (SerializerConstructionException e) {
            throw new IOException(e);
        }
    }

    public byte[] serialize() throws IOException {
        try {
            Serializer s = Bindings.getSerializer(this.binding);
            return s.serialize(this);
        }
        catch (SerializerConstructionException e) {
            throw new IOException(e);
        }
    }

    public void deserialize(byte[] data) throws IOException {
        try {
            Serializer s = Bindings.getSerializer(this.binding);
            this.init();
            s.deserialize(data, (Object)this);
        }
        catch (SerializerConstructionException e) {
            throw new IOException(e);
        }
    }

    public void readFile(File file) throws IOException {
        this.init();
        Files.readFile(file, this.binding, this);
    }

    public void writeFile(File file) throws IOException {
        Files.writeFile(file, this.binding, this);
    }

    public void assertIsValid() throws BindingException {
        this.binding.assertInstaceIsValid(this);
    }

    public void setField(String fieldName, Binding fieldBinding, Object field) throws BindingException {
        try {
            int index = this.binding.getComponentIndex(fieldName);
            if (index < 0) {
                throw new BindingException("There is no field " + fieldName);
            }
            Binding localFieldBinding = this.binding.getComponentBinding(index);
            if (localFieldBinding instanceof OptionalBinding) {
                OptionalBinding ob = (OptionalBinding)localFieldBinding;
                if (field == null) {
                    this.binding.setComponent(this, index, ob.createNoValue());
                } else {
                    Object newValue = Bindings.adapt(field, fieldBinding, ob.componentBinding);
                    this.binding.setComponent(this, index, ob.createValue(newValue));
                }
            } else {
                Object newValue = Bindings.adapt(field, fieldBinding, localFieldBinding);
                this.binding.setComponent(this, index, newValue);
            }
        }
        catch (AdaptException e) {
            if (e.getCause() != null && e.getCause() instanceof BindingException) {
                throw (BindingException)e.getCause();
            }
            throw new BindingException(e);
        }
    }

    public boolean hasField(String fieldName) throws BindingException {
        return this.binding.getComponentIndex(fieldName) >= 0;
    }

    public Binding getFieldBinding(String fieldName) throws BindingException {
        int index = this.binding.getComponentIndex(fieldName);
        if (index < 0) {
            return null;
        }
        Binding r = this.binding.getComponentBinding(index);
        if (r != null && r instanceof OptionalBinding) {
            r = ((OptionalBinding)r).componentBinding;
        }
        return r;
    }

    public Object getField(String fieldName) throws BindingException {
        int index = this.binding.type().getComponentIndex2(fieldName);
        if (index < 0) {
            return null;
        }
        return this.binding.getComponent(this, index);
    }

    public Object getField(String fieldName, Binding binding) throws BindingException {
        int index = this.binding.type().getComponentIndex2(fieldName);
        if (index < 0) {
            return null;
        }
        Object obj = this.binding.getComponent(this, index);
        if (obj == null) {
            return null;
        }
        Binding fieldBinding = this.binding.getComponentBinding(index);
        if (fieldBinding instanceof OptionalBinding) {
            fieldBinding = ((OptionalBinding)fieldBinding).componentBinding;
        }
        try {
            return Bindings.adapt(obj, fieldBinding, binding);
        }
        catch (AdaptException e) {
            if (e.getCause() != null && e.getCause() instanceof BindingException) {
                throw (BindingException)e.getCause();
            }
            throw new BindingException(e);
        }
    }

    public Object getFieldUnchecked(String fieldName) throws RuntimeBindingException {
        int index = this.binding.type().getComponentIndex2(fieldName);
        if (index < 0) {
            return null;
        }
        try {
            return this.binding.getComponent(this, index);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    public Binding getIdentifierBinding() throws BindingException {
        Datatype idType = this.binding.type().getIdentifierType();
        if (idType == null) {
            throw new BindingException("There is are no @Identifier fields in the bean");
        }
        return Bindings.getBinding(idType);
    }

    public Object getIdentifier() throws BindingException {
        int[] ids = this.binding.type().getIdentifiers();
        if (ids.length == 0) {
            throw new BindingException("There is are no @Identifier fields in the bean");
        }
        if (ids.length == 1) {
            return this.binding.getComponent(this, ids[0]);
        }
        RecordBinding rb = (RecordBinding)this.getIdentifierBinding();
        Object result = rb.createPartial();
        int ix = 0;
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            rb.setComponent(result, ix++, this.binding.getComponent(this, i));
            ++n2;
        }
        return result;
    }

    public static class Id
    extends Bean {
        protected Id() {
        }

        protected Id(Binding binding) {
            super(binding);
        }

        @Override
        public int hashCode() {
            int hash = 0;
            try {
                int[] nArray = this.binding.type().getIdentifiers();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    Object c = this.binding.getComponent(this, index);
                    Binding cb = this.binding.getComponentBinding(index);
                    hash = 13 * hash + cb.hashValue(c);
                    ++n2;
                }
            }
            catch (BindingException bindingException) {
                // empty catch block
            }
            return hash;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            Bean other = (Bean)obj;
            try {
                if (other.binding == this.binding) {
                    int[] nArray = this.binding.type().getIdentifiers();
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int index = nArray[n2];
                        Object tc = this.binding.getComponent(this, index);
                        Object oc = this.binding.getComponent(other, index);
                        Binding cb = this.binding.getComponentBinding(index);
                        if (!cb.equals(tc, oc)) {
                            return false;
                        }
                        ++n2;
                    }
                } else {
                    int[] nArray = this.binding.type().getIdentifiers();
                    int n = nArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Binding ocb;
                        int index = nArray[n3];
                        Object tc = this.binding.getComponent(this, index);
                        Object oc = this.binding.getComponent(other, index);
                        Binding tcb = this.binding.getComponentBinding(index);
                        if (!Bindings.equals(tcb, tc, ocb = other.binding.getComponentBinding(index), oc)) {
                            return false;
                        }
                        ++n3;
                    }
                }
                return true;
            }
            catch (BindingException e) {
                throw new RuntimeBindingException(e);
            }
        }
    }
}

