/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.type;

import java.util.HashSet;
import java.util.Set;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.accessor.reference.NameReference;
import org.simantics.databoard.annotations.Referable;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.IdentityPair;

@Referable
public class UnionType
extends Datatype {
    public Component[] components;

    public UnionType() {
    }

    public UnionType(Component ... components) {
        if (components.length == 0) {
            throw new IllegalArgumentException("need atleast 1 tag type");
        }
        this.components = components;
    }

    public void addComponent(String name, Datatype type) {
        Component c = new Component(name, type);
        if (this.components == null) {
            this.components = new Component[]{c};
        } else {
            Component[] newComponents = new Component[this.components.length + 1];
            System.arraycopy(this.components, 0, newComponents, 0, this.components.length);
            newComponents[this.components.length] = c;
            this.components = newComponents;
        }
    }

    public void removeComponent(String tagName) {
        int index = this.getComponentIndex2(tagName);
        if (index < 0) {
            return;
        }
        Component[] newComponents = new Component[this.components.length - 1];
        if (index > 0) {
            System.arraycopy(this.components, 0, newComponents, 0, index);
        }
        if (index < newComponents.length) {
            System.arraycopy(this.components, index + 1, newComponents, index, newComponents.length - index);
        }
        this.components = newComponents;
    }

    @Override
    protected void collectSubtypes(Set<Datatype> subtypes, Set<Datatype> recursiveSubtypes) {
        if (!subtypes.add(this)) {
            recursiveSubtypes.add(this);
            return;
        }
        Component[] componentArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            component.type.collectSubtypes(subtypes, recursiveSubtypes);
            ++n2;
        }
    }

    @Override
    protected boolean deepEquals(Object obj, Set<IdentityPair<Datatype, Datatype>> compareHistory) {
        IdentityPair<UnionType, UnionType> pair;
        if (this == obj) {
            return true;
        }
        if (!this.hasEqualMetadata(obj)) {
            return false;
        }
        if (!(obj instanceof UnionType)) {
            return false;
        }
        UnionType other = (UnionType)obj;
        if (this.components.length != other.components.length) {
            return false;
        }
        int i = 0;
        while (i < this.components.length) {
            Component lc = this.components[i];
            Component rc = other.components[i];
            if (!lc.name.equals(rc.name)) {
                return false;
            }
            ++i;
        }
        if (compareHistory == null) {
            compareHistory = new HashSet<IdentityPair<Datatype, Datatype>>(1);
        }
        if (compareHistory.contains(pair = new IdentityPair<UnionType, UnionType>(this, other))) {
            return true;
        }
        compareHistory.add(pair);
        int i2 = 0;
        while (i2 < this.components.length) {
            Component lc = this.components[i2];
            Component rc = other.components[i2];
            if (!lc.type.deepEquals(rc.type, compareHistory)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 42342345;
        Component[] componentArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            hash = hash * 7 + c.name.hashCode();
            ++n2;
        }
        return hash;
    }

    @Override
    public void accept(Datatype.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Datatype.Visitor<T> v) {
        return v.visit(this);
    }

    @Override
    public int getComponentCount() {
        return this.components.length;
    }

    @Override
    public Datatype getComponentType(ChildReference path) {
        if (path == null) {
            return this;
        }
        if (path instanceof IndexReference) {
            IndexReference ir = (IndexReference)path;
            return this.components[ir.index].type.getComponentType(path.childReference);
        }
        if (path instanceof NameReference) {
            NameReference nr = (NameReference)path;
            return this.getComponent((String)nr.name).type.getComponentType(path.childReference);
        }
        if (path instanceof LabelReference) {
            LabelReference lr = (LabelReference)path;
            try {
                Integer i = new Integer(lr.label);
                return this.getComponent((int)i.intValue()).type.getComponentType(path.childReference);
            }
            catch (NumberFormatException nfe) {
                return this.getComponent((String)lr.label).type.getComponentType(path.childReference);
            }
        }
        throw new IllegalArgumentException();
    }

    public Component getComponent(int i) {
        return this.components[i];
    }

    public Component[] getComponents() {
        return this.components;
    }

    public Integer getComponentIndex(String fieldName) {
        int i = 0;
        while (i < this.components.length) {
            if (this.components[i].name.equals(fieldName)) {
                return i;
            }
            ++i;
        }
        return null;
    }

    public int getComponentIndex2(String fieldName) {
        int i = 0;
        while (i < this.components.length) {
            if (this.components[i].name.equals(fieldName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Datatype getComponentType(String fieldName) {
        int index = this.getComponentIndex2(fieldName);
        if (index < 0) {
            return null;
        }
        return this.components[index].type;
    }

    public Component getComponent(String fieldName) {
        Component[] componentArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c.name.equals(fieldName)) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Datatype getComponentType(int index) {
        return this.components[index].type;
    }

    public boolean isEnumeration() {
        boolean isEnum = true;
        Component[] componentArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            isEnum &= c.type.equals(Datatypes.VOID);
            ++n2;
        }
        return isEnum;
    }
}

