/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import junit.framework.TestCase;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.util.RandomValue;

public class TestStringVariantBinding
extends TestCase {
    public void testAll() throws Exception {
        RandomValue rv = new RandomValue();
        VariantBinding vb = Bindings.STR_VARIANT;
        VariantBinding gen = (VariantBinding)Bindings.getMutableBinding(Datatypes.VARIANT);
        System.out.println(vb.create(Bindings.INTEGER, 5));
        System.out.println(vb.create(Bindings.LONG, 5L));
        System.out.println(vb.create(Bindings.STRING, "PA11_Valve/Pressure"));
        System.out.println(vb.create(Bindings.BOOLEAN, true));
        System.out.println(vb.create(Bindings.BOOLEAN, false));
        System.out.println(vb.getContent("I5"));
        System.out.println(vb.getContent("L5"));
        System.out.println(vb.getContent("SMoi"));
        System.out.println(vb.getContent("BAAE="));
        int i = 0;
        while (i < 10000) {
            int seed = i;
            rv.getRandom().setSeed(seed);
            rv.getRandom().nextLong();
            Object value = gen.accept(rv);
            String str = (String)Bindings.adaptUnchecked(value, gen, vb);
            Object value2 = Bindings.adaptUnchecked(str, vb, gen);
            System.out.println("Testcase: " + i);
            System.out.println("String: " + str);
            System.out.println("Value1: " + gen.printValueDefinition(value, true));
            System.out.println("Value2: " + gen.printValueDefinition(value2, true));
            System.out.println("Value3: " + vb.printValueDefinition(str, true));
            System.out.println("");
            TestStringVariantBinding.assertTrue(gen.equals(value, value2));
            ++i;
        }
    }
}

