/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.simantics.databoard.util.binary.BinaryMemory;
import org.simantics.databoard.util.binary.Blob;
import org.simantics.databoard.util.binary.RandomAccessBinary;

public class TestBlob {
    Blob blob;
    Blob[] level1;
    Blob[][] level2;

    @Before
    public void initData() throws Exception {
        BinaryMemory mem = new BinaryMemory(1600);
        this.blob = new Blob(mem);
        this.level1 = new Blob[10];
        this.level2 = new Blob[10][];
        int i = 0;
        while (i < 10) {
            this.level1[i] = this.blob.createSubBlob(i * 100, 160L);
            this.level2[i] = new Blob[10];
            int j = 0;
            while (j < 10) {
                this.level2[i][j] = this.level1[i].createSubBlob(i * 10, 16L);
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void testSize() throws Exception {
        Blob b = this.blob;
        Assert.assertEquals(b.length(), 1600L);
        int l = 0;
        while (l < 10) {
            b = this.level1[l];
            Assert.assertEquals(b.length(), 160L);
            int l2 = 0;
            while (l2 < 10) {
                b = this.level2[l][l2];
                Assert.assertEquals(b.length(), 16L);
                ++l2;
            }
            ++l;
        }
    }

    @Test
    public void testIsolation() throws Exception {
        Blob b = this.blob;
        this.testIsolation(b);
        this.testInsertRemove(b);
        int i = 0;
        while (i < 10) {
            b = this.level1[i];
            this.testIsolation(b);
            this.testInsertRemove(b);
            int j = 0;
            while (j < 10) {
                b = this.level2[i][j];
                this.testIsolation(b);
                this.testInsertRemove(b);
                ++j;
            }
            ++i;
        }
    }

    void testIsolation(Blob b) throws Exception {
        int parentCount = (int)b.getSource().length() / 4;
        int c = (int)b.length() / 4;
        b.position(0L);
        int i = 0;
        while (i < c) {
            b.writeInt(i ^ 0x58);
            ++i;
        }
        b.position(0L);
        i = 0;
        while (i < c) {
            Assert.assertEquals(i ^ 0x58, b.readInt());
            ++i;
        }
        try {
            b.readInt();
            Assert.fail("Did not catch boundary exceed");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        b.writeInt(50);
        Assert.assertEquals(c + 1, b.length() / 4L);
        Assert.assertEquals(parentCount + 1, b.getSource().length() / 4L);
        b.setLength(c * 4);
        Assert.assertEquals(c, b.length() / 4L);
        Assert.assertEquals(parentCount, b.getSource().length() / 4L);
    }

    public void testInsertRemove(Blob b) throws Exception {
        int c = (int)b.length() / 4;
        b.position(0L);
        int i = 0;
        while (i < c) {
            b.writeInt(i ^ 0x53);
            ++i;
        }
        b.position(4L);
        b.removeBytes(4L, RandomAccessBinary.ByteSide.Left);
        b.position(0L);
        Assert.assertEquals(83L, b.readInt());
        i = 2;
        while (i < c) {
            Assert.assertEquals(i ^ 0x53, b.readInt());
            ++i;
        }
        b.position(4L);
        b.insertBytes(4L, RandomAccessBinary.ByteSide.Left);
        b.writeInt(82);
        b.position(0L);
        i = 0;
        while (i < c) {
            Assert.assertEquals(i ^ 0x53, b.readInt());
            ++i;
        }
    }
}

