/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import java.io.File;
import java.util.TreeMap;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.file.FileMapAccessor;
import org.simantics.databoard.accessor.file.FileRecordAccessor;
import org.simantics.databoard.accessor.file.FileVariantAccessor;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.util.RandomValue;
import org.simantics.databoard.type.LongType;

public class PerformanceTest {
    public static void main(String[] args) throws Exception {
        long startTime;
        LongType time_type = new LongType("ms");
        Object time_binding = Bindings.getBinding(Long.class);
        Object float_sample_binding = Bindings.getBinding(FloatSample.class);
        Object integer_sample_binding = Bindings.getBinding(IntegerSample.class);
        Object float_record_binding = Bindings.getBinding(FloatRecord.class);
        Object integer_record_binding = Bindings.getBinding(IntegerRecord.class);
        int var_count = 1000;
        long interval = 10L;
        long duration = 10000000L;
        int block_size = 100;
        long steps = duration / interval;
        long iterations = steps / (long)block_size;
        System.out.println("Performance Test");
        System.out.println(" o variables = " + var_count);
        System.out.println(" o duration = " + duration / 1000L + " s");
        System.out.println(" o interval = " + interval + " ms");
        System.out.println(" o samples_in_write = " + block_size);
        System.out.println(" o At each step, a single sample is appended.");
        System.out.println(" o Initialization.");
        FileRecordAccessor[] variables = new FileRecordAccessor[var_count];
        FileMapAccessor[] maps = new FileMapAccessor[var_count];
        int i = 0;
        while (i < var_count) {
            File file = File.createTempFile("variable" + i, ".tmp");
            file.deleteOnExit();
            FileVariantAccessor fa = Accessors.createFile(file);
            Object record_binding = i < var_count / 2 ? float_record_binding : integer_record_binding;
            Object empty_record = ((Binding)record_binding).createDefault();
            fa.setContentValue((Binding)record_binding, empty_record);
            FileRecordAccessor ra = (FileRecordAccessor)fa.getContentAccessor();
            FileMapAccessor map = (FileMapAccessor)ra.getFieldAccessor("samples");
            variables[i] = ra;
            maps[i] = map;
            ++i;
        }
        RandomValue rv = new RandomValue();
        Object[] block1 = new FloatSample[block_size];
        Object[] block2 = new IntegerSample[block_size];
        int i2 = 0;
        while (i2 < block_size) {
            block1[i2] = new FloatSample();
            block2[i2] = new IntegerSample();
            ++i2;
        }
        Object[] times = new Long[block_size];
        long reportTime = startTime = System.currentTimeMillis();
        Long simulationTime = 0L;
        int i3 = 0;
        while ((long)i3 < iterations) {
            int vi = 0;
            while (vi < var_count) {
                int j;
                Object sample_binding;
                FileMapAccessor map = maps[vi];
                Object t = sample_binding = vi < var_count / 2 ? float_sample_binding : integer_sample_binding;
                if (sample_binding == float_sample_binding) {
                    j = 0;
                    while (j < block_size) {
                        block1[j].value = rv.getRandom().nextFloat();
                        times[j] = simulationTime + (long)j * interval;
                        ++j;
                    }
                    map.putAllNoflush((Binding)time_binding, (Binding)sample_binding, times, block1);
                } else {
                    j = 0;
                    while (j < block_size) {
                        block2[j].value = rv.getRandom().nextInt();
                        times[j] = simulationTime + (long)j * interval;
                        ++j;
                    }
                    map.putAllNoflush((Binding)time_binding, (Binding)sample_binding, times, block2);
                }
                ++vi;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - reportTime > 1000L) {
                System.out.println("Report:");
                System.out.println(" o Simulation Time: " + simulationTime / 1000L + " s");
                System.out.println(" o Time elapsed: " + (currentTime - startTime) / 1000L + " s");
                System.out.println(" o Samples in a variable: " + maps[0].size());
                reportTime = currentTime;
            }
            simulationTime = simulationTime + interval * (long)block_size;
            ++i3;
        }
        System.out.println("Simulation finished.");
        System.out.println(" o Closing files.");
        int vi = 0;
        while (vi < var_count) {
            variables[vi].flush();
            variables[vi].close();
            variables[vi].file().delete();
            ++vi;
        }
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        System.out.println(" o Elapsed Time: " + elapsedTime + " ms");
    }

    public static class FloatRecord {
        public Object id;
        public TreeMap<String, String> displayNames;
        public SamplingParameters samplingParameters;
        public TreeMap<Long, FloatSample> samples;
    }

    public static class FloatSample {
        public float value;
    }

    public static class IntegerRecord {
        public Object id;
        public TreeMap<String, String> displayNames;
        public SamplingParameters samplingParameters;
        public TreeMap<Long, IntegerSample> samples;
    }

    public static class IntegerSample {
        public int value;
    }

    public static class LocalizedText {
        public String locale;
        public String text;
    }

    public static class SamplingParameters {
        @Optional
        public Object deadband;
        @Optional
        public Object interval;
    }
}

