/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import org.junit.Before;
import org.junit.Test;
import org.simantics.databoard.parser.repository.DataTypeRepository;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;

public class ParserFailureTests {
    DataTypeRepository repository;

    @Before
    public void setUp() {
        this.repository = new DataTypeRepository();
    }

    @Test(expected=DataTypeSyntaxError.class)
    public void testIncorrectUnion1() throws DataTypeSyntaxError {
        this.repository.addDefinitions("type A = A | B");
    }

    @Test(expected=DataTypeSyntaxError.class)
    public void testIncorrectUnion2() throws DataTypeSyntaxError {
        this.repository.addDefinitions("type X = |Integer(range=0)");
    }

    @Test(expected=DataTypeSyntaxError.class)
    public void testUndefinedReference() throws DataTypeSyntaxError {
        this.repository.addDefinitions("type Foo = Bar");
    }

    @Test(expected=DataTypeSyntaxError.class)
    public void testCircularDefinition() throws DataTypeSyntaxError {
        this.repository.addDefinitions("type Foo = Bar type Bar = Foo ");
    }

    @Test(expected=DataTypeSyntaxError.class)
    public void testInvalidAttribute() throws DataTypeSyntaxError {
        this.repository.addDefinitions("type Foo = String(range=3)");
    }
}

