/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.parser;

import java.io.IOException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.FloatBinding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.file.RuntimeIOException;
import org.simantics.databoard.parser.PrintFormat;
import org.simantics.databoard.parser.repository.DataTypeRepository;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.UnionType;

public class DataValuePrinter
implements Binding.Visitor1 {
    Appendable out;
    int indentLevel = 0;
    PrintFormat format = PrintFormat.SINGLE_LINE;
    int nameCounter = 1;
    DataValueRepository repo;
    Object root;

    public static String writeValueSingleLine(Binding type, Object value) throws IOException, BindingException {
        StringBuffer sb = new StringBuffer();
        DataValuePrinter writable = new DataValuePrinter(sb, new DataValueRepository());
        writable.setFormat(PrintFormat.SINGLE_LINE);
        writable.print(type, value);
        return sb.toString();
    }

    public static String writeValueMultiLine(Binding type, Object value) throws IOException, BindingException {
        StringBuffer sb = new StringBuffer();
        DataValuePrinter writable = new DataValuePrinter(sb, new DataValueRepository());
        writable.setFormat(PrintFormat.MULTI_LINE);
        writable.print(type, value);
        return sb.toString();
    }

    public DataValuePrinter(Appendable out, DataValueRepository valueRepository) {
        this.setOutput(out);
        this.repo = valueRepository;
    }

    public DataValueRepository getValueRepository() {
        return this.repo;
    }

    public DataTypeRepository getTypeRepository() {
        return this.repo.getTypeRepository();
    }

    public void setOutput(Appendable out) {
        this.out = out;
    }

    public void setFormat(PrintFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.format = format;
    }

    public void print(MutableVariant variant) throws IOException, BindingException {
        this.print(variant.getBinding(), variant.getValue());
    }

    public void print(Binding binding, Object instance) throws IOException, BindingException {
        try {
            try {
                this.root = instance;
                binding.accept(this, instance);
            }
            catch (RuntimeIOException e) {
                throw e.getCause();
            }
            catch (RuntimeBindingException e) {
                throw e.getCause();
            }
        }
        finally {
            this.root = null;
        }
    }

    @Override
    public void visit(ArrayBinding b, Object instance) throws RuntimeIOException, RuntimeBindingException {
        try {
            Binding cb = b.getComponentBinding();
            if (instance == null) {
                this.out.append(this.format.openArray);
                this.out.append(this.format.closeArray);
                return;
            }
            int len = b.size(instance);
            this.out.append(this.format.openArray);
            int i = 0;
            while (i < len) {
                Object component = b.get(instance, i);
                cb.accept(this, component);
                if (i < len - 1) {
                    this.out.append(this.format.arraySeparator);
                    this.out.append(' ');
                }
                ++i;
            }
            this.out.append(this.format.closeArray);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    @Override
    public void visit(BooleanBinding b, Object instance) throws RuntimeIOException, RuntimeBindingException {
        try {
            boolean value = b.getValue_(instance);
            this.out.append(value ? this.format.True : this.format.False);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void visit(DoubleBinding b, Object instance) throws RuntimeIOException, RuntimeBindingException {
        try {
            this.out.append(b.getValue(instance).toString());
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void visit(FloatBinding b, Object instance) throws RuntimeIOException, RuntimeBindingException {
        try {
            this.out.append(b.getValue(instance).toString());
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void visit(IntegerBinding b, Object instance) throws RuntimeIOException, RuntimeBindingException {
        try {
            this.out.append(b.getValue(instance).toString());
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void visit(ByteBinding b, Object instance) throws RuntimeIOException, RuntimeBindingException {
        try {
            this.out.append(b.getValue(instance).toString());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    @Override
    public void visit(LongBinding b, Object instance) throws RuntimeIOException, RuntimeBindingException {
        try {
            this.out.append(b.getValue(instance).toString());
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void visit(OptionalBinding b, Object instance) throws RuntimeIOException, RuntimeBindingException {
        if (!b.hasValueUnchecked(instance)) {
            try {
                this.out.append(this.format.Null);
                return;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        try {
            instance = b.getValue(instance);
            b.getComponentBinding().accept(this, instance);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    String createNewName() {
        String name;
        while (this.repo.get(name = "obj" + this.nameCounter++) != null) {
        }
        return name;
    }

    @Override
    public void visit(RecordBinding b, Object instance) throws RuntimeIOException, RuntimeBindingException {
        block27: {
            boolean singleLine = this.format.newLine == null;
            boolean tuple = b.type().isTupleType();
            try {
                RecordType type = b.type();
                Binding[] bindings = b.getComponentBindings();
                Component[] components = b.type().getComponents();
                int len = bindings.length;
                if (type.isReferable() && instance != this.root) {
                    String name = this.repo.getName(instance);
                    if (name == null) {
                        name = this.createNewName();
                        this.repo.put(name, b, instance);
                    }
                    this.out.append(name);
                    return;
                }
                if (tuple) {
                    this.out.append(this.format.openTuple);
                    int i = 0;
                    while (i < len) {
                        String name;
                        Binding componentBinding = bindings[i];
                        Object value = b.getComponent(instance, i);
                        if (i > 0) {
                            this.out.append(this.format.arraySeparator);
                        }
                        if ((name = this.repo.getName(value)) != null) {
                            this.out.append(name);
                        } else {
                            componentBinding.accept(this, value);
                        }
                        ++i;
                    }
                    this.out.append(this.format.closeTuple);
                    break block27;
                }
                if (len == 0) {
                    this.out.append(this.format.openRecord);
                    this.out.append(this.format.closeRecord);
                    break block27;
                }
                if (singleLine) {
                    this.out.append(this.format.openRecord);
                    int i = 0;
                    while (i < len) {
                        OptionalBinding ob;
                        Binding componentBinding = bindings[i];
                        Object value = b.getComponent(instance, i);
                        if (!(componentBinding instanceof OptionalBinding) || (ob = (OptionalBinding)componentBinding).hasValue(value)) {
                            if (i > 0) {
                                this.out.append(this.format.arraySeparator);
                                this.out.append(' ');
                            }
                            String fieldName = components[i].name;
                            this.putFieldName(fieldName);
                            this.out.append(" = ");
                            String name = this.repo.getName(value);
                            if (name != null) {
                                this.out.append(name);
                            } else {
                                componentBinding.accept(this, value);
                            }
                        }
                        ++i;
                    }
                    this.out.append(this.format.closeRecord);
                    break block27;
                }
                this.out.append(this.format.openRecord);
                this.putLineFeed();
                this.addIndent();
                try {
                    OptionalBinding ob;
                    Object value;
                    Binding componentBinding;
                    int fieldsLeft = 0;
                    int i = 0;
                    while (i < len) {
                        componentBinding = bindings[i];
                        value = b.getComponent(instance, i);
                        if (!(componentBinding instanceof OptionalBinding) || (ob = (OptionalBinding)componentBinding).hasValue(value)) {
                            ++fieldsLeft;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < len) {
                        componentBinding = bindings[i];
                        value = b.getComponent(instance, i);
                        if (!(componentBinding instanceof OptionalBinding) || (ob = (OptionalBinding)componentBinding).hasValue(value)) {
                            this.putIndent();
                            String fieldName = components[i].name;
                            this.putFieldName(fieldName);
                            this.out.append(" = ");
                            String name = this.repo.getName(value);
                            if (name != null) {
                                this.out.append(name);
                            } else {
                                componentBinding.accept(this, value);
                            }
                            if (--fieldsLeft > 0) {
                                this.out.append(this.format.arraySeparator);
                            }
                            this.putLineFeed();
                        }
                        ++i;
                    }
                }
                finally {
                    this.decIndent();
                }
                this.putIndent();
                this.out.append(this.format.closeRecord);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            catch (BindingException e) {
                throw new RuntimeBindingException(e);
            }
        }
    }

    @Override
    public void visit(StringBinding b, Object instance) throws RuntimeIOException, RuntimeBindingException {
        try {
            boolean singleLineFormat = this.format.newLine == null;
            String unescapedString = b.getValue(instance);
            boolean canUseLongString = true;
            boolean hasCharsToBeEscaped = false;
            boolean hasLineFeeds = false;
            char c = '\u0000';
            char pc = '\u0000';
            char ppc = '\u0000';
            int i = 0;
            while (i < unescapedString.length()) {
                ppc = pc;
                pc = c;
                c = unescapedString.charAt(i);
                canUseLongString &= c != '\"' && pc != '\"' && ppc != '\"';
                switch (c) {
                    case '\b': {
                        hasCharsToBeEscaped = true;
                    }
                    case '\f': {
                        hasCharsToBeEscaped = true;
                    }
                    case '\\': {
                        hasCharsToBeEscaped = true;
                    }
                    case '\"': {
                        hasCharsToBeEscaped = true;
                    }
                    case '\'': {
                        hasCharsToBeEscaped = true;
                    }
                    case '\n': {
                        hasCharsToBeEscaped = true;
                        hasLineFeeds = true;
                    }
                    case '\r': {
                        hasCharsToBeEscaped = true;
                        hasLineFeeds = true;
                    }
                    case '\t': {
                        hasCharsToBeEscaped = true;
                    }
                }
                ++i;
            }
            if (canUseLongString && hasCharsToBeEscaped) {
                if (singleLineFormat && hasLineFeeds) {
                    this.putShortString(unescapedString);
                } else {
                    this.putLongString(unescapedString);
                }
            } else {
                this.putShortString(unescapedString);
            }
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void visit(UnionBinding b, Object instance) throws RuntimeIOException, RuntimeBindingException {
        try {
            UnionType datatype = b.type();
            int ordinal = b.getTag(instance);
            Object component = b.getValue(instance);
            Binding cb = b.getComponentBindings()[ordinal];
            String tagName = datatype.components[ordinal].name;
            this.putFieldName(tagName);
            this.out.append(' ');
            cb.accept(this, component);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    @Override
    public void visit(MapBinding b, Object entity) {
        block16: {
            boolean singleLine = this.format.newLine == null;
            try {
                Binding keyBinding = b.getKeyBinding();
                Binding valueBinding = b.getValueBinding();
                int len = b.size(entity);
                this.out.append("map ");
                if (len == 0) {
                    this.out.append(this.format.openRecord);
                    this.out.append(this.format.closeRecord);
                    break block16;
                }
                if (singleLine) {
                    this.out.append(this.format.openRecord);
                    Object[] keys = b.getKeys(entity);
                    int i = 0;
                    while (i < len) {
                        Object key = keys[i];
                        Object value = b.get(entity, key);
                        if (i > 0) {
                            this.out.append(this.format.arraySeparator);
                            this.out.append(' ');
                        }
                        keyBinding.accept(this, key);
                        this.out.append(" = ");
                        String name = this.repo.getName(value);
                        if (name != null) {
                            this.out.append(name);
                        } else {
                            valueBinding.accept(this, value);
                        }
                        ++i;
                    }
                    this.out.append(this.format.closeRecord);
                    break block16;
                }
                this.out.append(this.format.openRecord);
                this.putLineFeed();
                this.addIndent();
                try {
                    Object[] keys = b.getKeys(entity);
                    int i = 0;
                    while (i < len) {
                        Object key = keys[i];
                        Object value = b.get(entity, key);
                        this.putIndent();
                        keyBinding.accept(this, key);
                        this.out.append(" = ");
                        String name = this.repo.getName(value);
                        if (name != null) {
                            this.out.append(name);
                        } else {
                            valueBinding.accept(this, value);
                        }
                        if (i < len - 1) {
                            this.out.append(this.format.arraySeparator);
                        }
                        this.putLineFeed();
                        ++i;
                    }
                }
                finally {
                    this.decIndent();
                }
                this.putIndent();
                this.out.append(this.format.closeRecord);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            catch (BindingException e) {
                throw new RuntimeBindingException(e);
            }
        }
    }

    @Override
    public void visit(VariantBinding b, Object variant) {
        try {
            Binding valueBinding = b.getContentBinding(variant);
            Object value = b.getContent(variant, valueBinding);
            Datatype type = b.getContentType(variant);
            valueBinding.accept(this, value);
            this.out.append(" : ");
            this.out.append(type.toSingleLineString());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    private void putLongString(String unescapedString) throws IOException {
        this.out.append(this.format.openLongString);
        int i = 0;
        while (i < unescapedString.length()) {
            char c = unescapedString.charAt(i);
            switch (c) {
                case '\b': {
                    this.out.append("\\b");
                    break;
                }
                case '\f': {
                    this.out.append("\\f");
                    break;
                }
                case '\\': {
                    this.out.append("\\\\");
                    break;
                }
                case '\'': {
                    this.out.append("\\'");
                    break;
                }
                case '\"': {
                    this.out.append("\\\"");
                    break;
                }
                case '\t': {
                    this.out.append("\\t");
                    break;
                }
                default: {
                    this.out.append(c);
                }
            }
            ++i;
        }
        this.out.append(this.format.closeLongString);
    }

    private void putShortString(String unescapedString) throws IOException {
        this.out.append(this.format.openString);
        int i = 0;
        while (i < unescapedString.length()) {
            char c = unescapedString.charAt(i);
            switch (c) {
                case '\b': {
                    this.out.append("\\b");
                    break;
                }
                case '\f': {
                    this.out.append("\\f");
                    break;
                }
                case '\\': {
                    this.out.append("\\\\");
                    break;
                }
                case '\'': {
                    this.out.append("\\'");
                    break;
                }
                case '\"': {
                    this.out.append("\\\"");
                    break;
                }
                case '\n': {
                    this.out.append("\\n");
                    break;
                }
                case '\r': {
                    this.out.append("\\r");
                    break;
                }
                case '\t': {
                    this.out.append("\\t");
                    break;
                }
                default: {
                    this.out.append(c);
                }
            }
            ++i;
        }
        this.out.append(this.format.closeString);
    }

    private void putFieldName(String fieldName) throws IOException {
        char c;
        boolean hasCharsToBeEscaped = false;
        int i = 0;
        while (i < fieldName.length()) {
            c = fieldName.charAt(i);
            switch (c) {
                case '\b': {
                    hasCharsToBeEscaped = true;
                    break;
                }
                case '\f': {
                    hasCharsToBeEscaped = true;
                    break;
                }
                case '\\': {
                    hasCharsToBeEscaped = true;
                    break;
                }
                case '\"': {
                    hasCharsToBeEscaped = true;
                    break;
                }
                case '\'': {
                    hasCharsToBeEscaped = true;
                    break;
                }
                case '\n': {
                    hasCharsToBeEscaped = true;
                    break;
                }
                case '\r': {
                    hasCharsToBeEscaped = true;
                    break;
                }
                case '\t': {
                    hasCharsToBeEscaped = true;
                }
            }
            ++i;
        }
        if (hasCharsToBeEscaped) {
            this.out.append('\'');
            i = 0;
            while (i < fieldName.length()) {
                c = fieldName.charAt(i);
                switch (c) {
                    case '\b': {
                        this.out.append("\\b");
                        break;
                    }
                    case '\f': {
                        this.out.append("\\f");
                        break;
                    }
                    case '\\': {
                        this.out.append("\\\\");
                        break;
                    }
                    case '\"': {
                        this.out.append("\\\"");
                        break;
                    }
                    case '\'': {
                        this.out.append("\\'");
                        break;
                    }
                    case '\n': {
                        this.out.append("\\n");
                        break;
                    }
                    case '\r': {
                        this.out.append("\\r");
                        break;
                    }
                    case '\t': {
                        this.out.append("\\t");
                        break;
                    }
                    default: {
                        this.out.append(c);
                    }
                }
                ++i;
            }
            this.out.append('\'');
        } else {
            this.out.append(fieldName);
        }
    }

    private void putIndent() throws IOException {
        if (this.format.indent == null) {
            return;
        }
        int j = 0;
        while (j < this.indentLevel) {
            this.out.append(this.format.indent);
            ++j;
        }
    }

    private void putLineFeed() throws IOException {
        if (this.format.newLine == null) {
            return;
        }
        this.out.append(this.format.newLine);
    }

    private void addIndent() {
        if (this.format.indent == null) {
            return;
        }
        ++this.indentLevel;
    }

    private void decIndent() {
        if (this.format.indent == null) {
            return;
        }
        --this.indentLevel;
    }
}

