/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.container;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.impl.TreeMapBinding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataFormatException;
import org.simantics.databoard.container.FormatHandler;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.binary.BinaryFile;

public class DataContainers {
    private static final Serializer STRING_SERIALIZER = Bindings.getSerializerUnchecked(Bindings.STRING);
    private static final Serializer INTEGER_SERIALIZER = Bindings.getSerializerUnchecked(Bindings.INTEGER);
    private static final Serializer METADATA_SERIALIZER = Bindings.getSerializerUnchecked(new TreeMapBinding(Bindings.STRING, Bindings.VARIANT));
    private static final Serializer DATATYPE_SERIALIZER = Bindings.getSerializerUnchecked(Datatype.class);
    private static final Serializer VARIANT_SERIALIZER = Bindings.getSerializerUnchecked(Bindings.VARIANT);
    private static final Serializer DATA_CONTAINER_SERIALIZER = Bindings.getSerializerUnchecked(DataContainer.class);

    public static DataContainer readHeader(DataInput input) throws IOException {
        String format = (String)STRING_SERIALIZER.deserialize(input);
        int version = (Integer)INTEGER_SERIALIZER.deserialize(input);
        TreeMap metadata = (TreeMap)METADATA_SERIALIZER.deserialize(input);
        return new DataContainer(format, version, metadata, null);
    }

    public static DataContainer requireHeader(DataInput input, String format, int version) {
        try {
            DataContainer header = DataContainers.readHeader(input);
            if (!format.equals(header.format) || version != header.version) {
                return header;
            }
            return null;
        }
        catch (Throwable t) {
            return new DataContainer("unknown", 0, null, null);
        }
    }

    public static DataContainer validateHeader(File file, String format, int version) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        try {
            DataContainer dataContainer = DataContainers.requireHeader(new DataInputStream(stream), format, version);
            return dataContainer;
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    public static DataContainer readHeader(File input) throws IOException {
        BinaryFile rf = new BinaryFile(input);
        try {
            DataContainer dataContainer = DataContainers.readHeader(rf);
            return dataContainer;
        }
        finally {
            rf.close();
        }
    }

    public static DataContainer readFile(DataInput input) throws IOException {
        DataContainer result = DataContainers.readHeader(input);
        result.content = (Variant)VARIANT_SERIALIZER.deserialize(input);
        return result;
    }

    public static <T> T readFile(DataInput input, Map<String, FormatHandler<T>> handlers) throws Exception {
        DataContainer result = DataContainers.readHeader(input);
        FormatHandler<T> handler = handlers.get(String.valueOf(result.format) + ":" + result.version);
        if (handler == null) {
            throw new DataFormatException("Unknown data format " + result.format + " version " + result.version + ".");
        }
        Binding binding = handler.getBinding();
        Datatype contentType = (Datatype)DATATYPE_SERIALIZER.deserialize(input);
        if (!binding.type().equals(contentType)) {
            throw new DataFormatException("Content type didn't match the type expected for the format " + result.format + " version " + result.version + ".");
        }
        Object value = Bindings.getSerializerUnchecked(binding).deserialize(input);
        result.content = new Variant(binding, value);
        return handler.process(result);
    }

    public static DataContainer readFile(File input) throws IOException {
        BinaryFile rf = new BinaryFile(input);
        try {
            DataContainer dataContainer = DataContainers.readFile(rf);
            return dataContainer;
        }
        finally {
            rf.close();
        }
    }

    public static <T> T readFile(File input, Map<String, FormatHandler<T>> handlers) throws Exception {
        BinaryFile rf = new BinaryFile(input);
        try {
            T t = DataContainers.readFile(rf, handlers);
            return t;
        }
        finally {
            rf.close();
        }
    }

    public static void writeHeader(DataOutput output, DataContainer container) throws IOException {
        STRING_SERIALIZER.serialize(output, (Object)container.format);
        INTEGER_SERIALIZER.serialize(output, (Object)container.version);
        METADATA_SERIALIZER.serialize(output, container.metadata);
    }

    public static void writeFile(DataOutput output, DataContainer container) throws IOException {
        DataContainers.writeHeader(output, container);
        VARIANT_SERIALIZER.serialize(output, (Object)container.content);
    }

    public static void writeFile(File output, DataContainer container) throws IOException {
        BinaryFile wf = new BinaryFile(output);
        try {
            DataContainers.writeFile(wf, container);
        }
        finally {
            wf.close();
        }
    }

    public static byte[] writeFile(DataContainer container) throws IOException {
        return DATA_CONTAINER_SERIALIZER.serialize(container);
    }
}

