/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.reflection.ClassBinding;
import org.simantics.databoard.binding.reflection.ClassInfo;
import org.simantics.databoard.type.RecordType;

class RecordClassBinding
extends ClassBinding {
    public RecordClassBinding(ClassInfo ci, RecordType type) {
        super(ci);
        if (ci == null) {
            throw new IllegalArgumentException("null ClassInfo");
        }
        this.type = type;
        this.componentBindings = new Binding[ci.fields.length];
    }

    @Override
    public Object createPartial() throws BindingException {
        try {
            if (this.ci.noArgsConstructor != null) {
                return this.ci.noArgsConstructor.newInstance(new Object[0]);
            }
            Object[] values = new Object[this.ci.fields.length];
            int i = 0;
            while (i < values.length) {
                Binding fb = this.componentBindings[i];
                values[i] = fb.createDefault();
                ++i;
            }
            return this.ci.argsConstructor.newInstance(values);
        }
        catch (InstantiationException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (InvocationTargetException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public Object create(Object ... values) throws BindingException {
        if (this.ci.argsConstructor != null) {
            try {
                return this.ci.argsConstructor.newInstance(values);
            }
            catch (IllegalArgumentException e) {
                throw new BindingException(e);
            }
            catch (InstantiationException e) {
                throw new BindingException(e);
            }
            catch (IllegalAccessException e) {
                throw new BindingException(e);
            }
            catch (InvocationTargetException e) {
                throw new BindingException(e);
            }
        }
        try {
            Object result = null;
            result = this.ci.noArgsConstructor != null ? this.ci.noArgsConstructor.newInstance(new Object[0]) : this.ci.clazz.newInstance();
            int i = 0;
            while (i < this.ci.fields.length) {
                Object value = values[i];
                Field f = this.ci.fields[i];
                Class<?> type = f.getType();
                Method setter = this.ci.setters[i];
                if (setter != null) {
                    if (type == Integer.TYPE) {
                        setter.invoke(result, (Integer)value);
                    } else if (type == Long.TYPE) {
                        setter.invoke(result, (Long)value);
                    } else if (type == Float.TYPE) {
                        setter.invoke(result, (Float)value);
                    } else if (type == Double.TYPE) {
                        setter.invoke(result, (Double)value);
                    } else if (type == Boolean.TYPE) {
                        setter.invoke(result, (Boolean)value);
                    } else {
                        setter.invoke(result, value);
                    }
                } else if (type == Integer.TYPE) {
                    f.setInt(result, (Integer)value);
                } else if (type == Long.TYPE) {
                    f.setLong(result, (Long)value);
                } else if (type == Float.TYPE) {
                    f.setFloat(result, ((Float)value).floatValue());
                } else if (type == Double.TYPE) {
                    f.setDouble(result, (Double)value);
                } else if (type == Boolean.TYPE) {
                    f.setBoolean(result, (Boolean)value);
                } else {
                    f.set(result, value);
                }
                ++i;
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (InvocationTargetException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public Object getComponent(Object obj, int index) throws BindingException {
        try {
            Field f = this.ci.fields[index];
            Class<?> type = f.getType();
            if (type.isPrimitive()) {
                if (type == Integer.TYPE) {
                    return f.getInt(obj);
                }
                if (type == Byte.TYPE) {
                    return f.getByte(obj);
                }
                if (type == Boolean.TYPE) {
                    return f.getBoolean(obj);
                }
                if (type == Float.TYPE) {
                    return Float.valueOf(f.getFloat(obj));
                }
                if (type == Double.TYPE) {
                    return f.getDouble(obj);
                }
                if (type == Long.TYPE) {
                    return f.getLong(obj);
                }
                return f.get(obj);
            }
            return f.get(obj);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            Field getter = this.ci.fields[index];
            if (getter != null) {
                try {
                    return getter.get(obj);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            throw new BindingException(e);
        }
    }

    @Override
    public boolean isInstance(Object obj) {
        return this.ci.clazz.isInstance(obj);
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    public Class<?> getComponentClass(int index) {
        return this.ci.fields[index].getDeclaringClass();
    }

    @Override
    public void setComponent(Object obj, int index, Object value) throws BindingException {
        try {
            Method setter = this.ci.setters[index];
            if (setter != null) {
                setter.invoke(obj, value);
            } else {
                Field f = this.ci.fields[index];
                Class<?> type = f.getType();
                if (type.isPrimitive()) {
                    if (type == Integer.TYPE) {
                        f.setInt(obj, (Integer)value);
                    } else if (type == Byte.TYPE) {
                        f.setByte(obj, (Byte)value);
                    } else if (type == Boolean.TYPE) {
                        f.setBoolean(obj, (Boolean)value);
                    } else if (type == Float.TYPE) {
                        f.setFloat(obj, ((Float)value).floatValue());
                    } else if (type == Double.TYPE) {
                        f.setDouble(obj, (Double)value);
                    } else if (type == Long.TYPE) {
                        f.setLong(obj, (Long)value);
                    } else {
                        f.set(obj, value);
                    }
                } else {
                    f.set(obj, value);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new BindingException(e);
        }
    }

    @Override
    public void setComponents(Object obj, Object ... value) throws BindingException {
        try {
            int i = 0;
            while (i < this.ci.fields.length) {
                Method setter = this.ci.setters[i];
                if (setter != null) {
                    setter.invoke(obj, value[i]);
                } else {
                    Field f = this.ci.fields[i];
                    Class<?> type = f.getType();
                    if (type.isPrimitive()) {
                        if (type == Integer.TYPE) {
                            f.setInt(obj, (Integer)value[i]);
                        } else if (type == Byte.TYPE) {
                            f.setByte(obj, (Byte)value[i]);
                        } else if (type == Boolean.TYPE) {
                            f.setBoolean(obj, (Boolean)value[i]);
                        } else if (type == Float.TYPE) {
                            f.setFloat(obj, ((Float)value[i]).floatValue());
                        } else if (type == Double.TYPE) {
                            f.setDouble(obj, (Double)value[i]);
                        } else if (type == Long.TYPE) {
                            f.setLong(obj, (Long)value[i]);
                        } else {
                            f.set(obj, value[i]);
                        }
                    } else {
                        f.set(obj, value[i]);
                    }
                }
                ++i;
            }
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (InvocationTargetException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public void setBoolean(Object r, int index, boolean z) throws BindingException {
        try {
            this.ci.fields[index].setBoolean(r, z);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public boolean getBoolean(Object r, int index) throws BindingException {
        try {
            return this.ci.fields[index].getBoolean(r);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public void setByte(Object r, int index, byte x) throws BindingException {
        try {
            this.ci.fields[index].setByte(r, x);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public byte getByte(Object r, int index) throws BindingException {
        try {
            return this.ci.fields[index].getByte(r);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public void setInt(Object r, int index, int x) throws BindingException {
        try {
            this.ci.fields[index].setInt(r, x);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public int getInt(Object r, int index) throws BindingException {
        try {
            return this.ci.fields[index].getInt(r);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public void setLong(Object r, int index, long x) throws BindingException {
        try {
            this.ci.fields[index].setLong(r, x);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public long getLong(Object r, int index) throws BindingException {
        try {
            return this.ci.fields[index].getLong(r);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public void setFloat(Object r, int index, float x) throws BindingException {
        try {
            this.ci.fields[index].setFloat(r, x);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public float getFloat(Object r, int index) throws BindingException {
        try {
            return this.ci.fields[index].getFloat(r);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public void setDouble(Object r, int index, double x) throws BindingException {
        try {
            this.ci.fields[index].setDouble(r, x);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public double getDouble(Object r, int index) throws BindingException {
        try {
            return this.ci.fields[index].getDouble(r);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
    }
}

