/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import java.lang.reflect.Array;
import java.util.Iterator;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.ArrayType;

public class ObjectArrayBinding
extends ArrayBinding {
    public ObjectArrayBinding(ArrayType type, Binding componentBinding) {
        super(type, componentBinding);
        if (type == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.type = type;
    }

    public ObjectArrayBinding(Binding componentBinding) {
        this(new ArrayType(componentBinding.type()), componentBinding);
    }

    @Override
    public Object create(int length, Iterator<Object> values) {
        Object[] array = new Object[length];
        int i = 0;
        while (i < length) {
            array[i] = values.next();
            ++i;
        }
        return array;
    }

    @Override
    public Object create() {
        return new Object[0];
    }

    @Override
    public Object create(Object[] values) {
        return values.clone();
    }

    @Override
    public void readFrom(Binding srcBinding, Object src, Object dst) throws BindingException {
        ArrayBinding sb = (ArrayBinding)srcBinding;
        Binding scb = sb.getComponentBinding();
        Binding dcb = this.getComponentBinding();
        Object[] d = (Object[])dst;
        if (d.length != sb.size(src)) {
            throw new BindingException("Object[] is length immutable");
        }
        int i = 0;
        while (i < d.length) {
            Object sc = sb.get(src, i);
            Object dc = d[i];
            d[i] = dcb.readFromTry(scb, sc, dc);
            ++i;
        }
    }

    @Override
    public Object readFromTry(Binding srcBinding, Object src, Object dst) throws BindingException {
        ArrayBinding sb = (ArrayBinding)srcBinding;
        Binding scb = sb.getComponentBinding();
        Binding dcb = this.getComponentBinding();
        Object[] d = (Object[])dst;
        int srcSize = sb.size(src);
        if (d.length != srcSize) {
            Object[] oldD = (Object[])dst;
            d = new Object[srcSize];
            int X2 = Math.min(oldD.length, srcSize);
            int i = 0;
            while (i < X2) {
                Object sc = sb.get(src, i);
                Object dc = d[i];
                d[i] = dcb.readFromTry(scb, sc, dc);
                ++i;
            }
            if (X2 < srcSize) {
                try {
                    Adapter cloner = Bindings.adapterFactory.getAdapter(scb, dcb, false, true);
                    int i2 = X2;
                    while (i2 < srcSize) {
                        Object dc;
                        Object sc = sb.get(src, i2);
                        d[i2] = dc = cloner.adapt(sc);
                        ++i2;
                    }
                }
                catch (AdaptException e) {
                    throw new BindingException(e);
                }
                catch (AdapterConstructionException e) {
                    throw new BindingException(e);
                }
            }
        } else {
            int i = 0;
            while (i < d.length) {
                Object sc = sb.get(src, i);
                Object dc = d[i];
                d[i] = dcb.readFromTry(scb, sc, dc);
                ++i;
            }
        }
        return d;
    }

    @Override
    public void add(Object array, int index, Object element) throws BindingException, IndexOutOfBoundsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Object array, int index, int count) throws BindingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getAll(Object array, Object[] result) throws BindingException {
        Object[] list = (Object[])array;
        System.arraycopy(list, 0, result, 0, list.length);
    }

    @Override
    public Object get(Object array, int index) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", Object[] expected");
        }
        return ((Object[])array)[index];
    }

    @Override
    public void set(Object array, int index, Object value) throws BindingException {
        Object[] list = (Object[])array;
        list[index] = value;
    }

    @Override
    public int size(Object array) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", Object[] expected");
        }
        return ((Object[])array).length;
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof Object[];
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public void setSize(Object array, int newSize) throws BindingException {
        int oldSize = Array.getLength(array);
        if (oldSize == newSize) {
            return;
        }
        throw new BindingException("Object[] is length immutable");
    }

    @Override
    public boolean isResizable() {
        return false;
    }
}

