/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.UnsupportedOperationException;
import org.simantics.databoard.type.IntegerType;

public class IntegerBindingDefault
extends IntegerBinding {
    public IntegerBindingDefault(IntegerType type) {
        super(type);
    }

    @Override
    public Object create(int value) {
        return value;
    }

    @Override
    public Object create(Integer value) {
        return value;
    }

    @Override
    public Object create(Number value) {
        if (value.getClass() == Integer.class) {
            return value;
        }
        return value.intValue();
    }

    @Override
    public Object create(String value) {
        return Integer.parseInt(value);
    }

    @Override
    public Integer getValue(Object obj) throws BindingException {
        if (obj.getClass() != Integer.class) {
            throw new BindingException("Unexpected class " + obj.getClass().getSimpleName() + ", Integer expected");
        }
        return (Integer)obj;
    }

    @Override
    public int getValue_(Object obj) throws BindingException {
        if (obj.getClass() != Integer.class) {
            throw new BindingException("Unexpected class " + obj.getClass().getSimpleName() + ", Integer expected");
        }
        return (Integer)obj;
    }

    @Override
    public void setValue(Object obj, Number value) throws BindingException {
        throw new UnsupportedOperationException("Cannot change the value of immutable java.lang.Integer");
    }

    @Override
    public void setValue(Object obj, int value) throws BindingException {
        throw new UnsupportedOperationException("Cannot change the value of immutable java.lang.Integer");
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof Integer;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public int compare(Object o1, Object o2) {
        Integer d1 = (Integer)o1;
        Integer d2 = (Integer)o2;
        int d = d1 - d2;
        return d == 0 ? 0 : (d < 0 ? -1 : 1);
    }
}

