/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.UnsupportedOperationException;
import org.simantics.databoard.type.ByteType;

public class ByteBindingDefault
extends ByteBinding {
    public ByteBindingDefault(ByteType type) {
        super(type);
    }

    @Override
    public Object create(byte value) {
        return value;
    }

    @Override
    public Object create(Byte value) {
        return value;
    }

    @Override
    public Object create(Number value) {
        if (value.getClass() == Byte.class) {
            return value;
        }
        return value.byteValue();
    }

    @Override
    public Object create(String value) {
        return Byte.parseByte(value);
    }

    @Override
    public Byte getValue(Object obj) throws BindingException {
        if (obj.getClass() != Byte.class) {
            throw new BindingException("Unexpected class " + obj.getClass().getSimpleName() + ", Byte expected");
        }
        return (Byte)obj;
    }

    @Override
    public byte getValue_(Object obj) throws BindingException {
        if (obj.getClass() != Byte.class) {
            throw new BindingException("Unexpected class " + obj.getClass().getSimpleName() + ", Byte expected");
        }
        return (Byte)obj;
    }

    @Override
    public void setValue(Object obj, Number value) throws BindingException {
        throw new UnsupportedOperationException("Cannot change the value of immutable java.lang.Byte");
    }

    @Override
    public void setValue(Object obj, byte value) throws BindingException {
        throw new UnsupportedOperationException("Cannot change the value of immutable java.lang.Byte");
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof Byte;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public int compare(Object o1, Object o2) {
        Byte d1 = (Byte)o1;
        Byte d2 = (Byte)o2;
        int d = d1 - d2;
        return d == 0 ? 0 : (d < 0 ? -1 : 1);
    }
}

