/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.impl.OptionalBindingDefault;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;

public class ThrowableBinding
extends RecordBinding {
    private Class<Throwable> boundClass;
    private Constructor<Throwable> constructor;
    private Constructor<Throwable> constructorNoArgs;

    public ThrowableBinding(Class<Throwable> classToBindTo) throws BindingConstructionException {
        this.boundClass = classToBindTo;
        this.type = new RecordType();
        RecordType rt = (RecordType)this.type;
        rt.addComponent("detailMessage", new OptionalType(Datatypes.STRING));
        this.componentBindings = new Binding[1];
        this.componentBindings[0] = new OptionalBindingDefault(Bindings.STRING);
        try {
            this.constructor = this.boundClass.getConstructor(String.class);
            this.constructor.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new BindingConstructionException(e);
        }
        catch (NoSuchMethodException e) {
            throw new BindingConstructionException(e);
        }
        try {
            this.constructorNoArgs = this.boundClass.getConstructor(new Class[0]);
            this.constructorNoArgs.setAccessible(true);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Override
    public Object getComponent(Object obj, int index) throws BindingException {
        if (index != 0) {
            throw new BindingException("Index out of range");
        }
        if (!(obj instanceof Throwable)) {
            throw new BindingException("not Throwable");
        }
        Throwable t = (Throwable)obj;
        return t.getMessage();
    }

    @Override
    public Object create(Object ... values) throws BindingException {
        if (values.length != 1) {
            throw new BindingException("Invalid argument");
        }
        try {
            return this.constructor.newInstance(values);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (InstantiationException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
        catch (InvocationTargetException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public Object createPartial() throws BindingException {
        if (this.constructorNoArgs != null) {
            try {
                return this.constructorNoArgs.newInstance(new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new BindingException(e);
            }
            catch (InstantiationException e) {
                throw new BindingException(e);
            }
            catch (IllegalAccessException e) {
                throw new BindingException(e);
            }
            catch (InvocationTargetException e) {
                throw new BindingException(e);
            }
        }
        try {
            return this.constructor.newInstance(null);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e);
        }
        catch (InstantiationException e) {
            throw new BindingException(e);
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e);
        }
        catch (InvocationTargetException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public void setComponents(Object obj, Object ... value) throws BindingException {
        throw new BindingException("Cannot set message to Throwable");
    }

    @Override
    public void setComponent(Object obj, int index, Object value) throws BindingException {
        throw new BindingException("Cannot set message to Throwable");
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof Throwable;
    }
}

