/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.classfactory;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.TreeMap;
import org.simantics.databoard.annotations.ArgumentImpl;
import org.simantics.databoard.annotations.LengthImpl;
import org.simantics.databoard.annotations.MIMETypeImpl;
import org.simantics.databoard.annotations.PatternImpl;
import org.simantics.databoard.annotations.RangeImpl;
import org.simantics.databoard.annotations.UnitImpl;
import org.simantics.databoard.binding.classfactory.TypeClassFactory;
import org.simantics.databoard.binding.classfactory.TypeClassSubFactory;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.binding.reflection.BindingRequest;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.VariantType;

public class ImmutableClassesFactory
implements TypeClassSubFactory {
    @Override
    public BindingRequest construct(TypeClassFactory mainFactory, Datatype type) throws BindingConstructionException {
        ArrayList<Annotation> annotations;
        if (type instanceof ArrayType) {
            String length;
            annotations = new ArrayList<Annotation>();
            ArrayType at = (ArrayType)type;
            BindingRequest cbr = this.construct(mainFactory, at.componentType);
            if (cbr == null) {
                cbr = mainFactory.getClass(at.componentType);
            }
            if ((length = (String)at.metadata.get("length")) != null) {
                annotations.add(new LengthImpl(length));
            }
            if (cbr.getClazz() != null) {
                Annotation[] annotationArray = cbr.annotations;
                int n = cbr.annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation a = annotationArray[n2];
                    annotations.add(a);
                    ++n2;
                }
                Class<?> arrayClass = Array.newInstance(cbr.getClazz(), 0).getClass();
                return new BindingRequest(arrayClass, annotations);
            }
        }
        if (type instanceof MapType) {
            MapType mt = (MapType)type;
            ArrayList<Annotation> annotations2 = new ArrayList<Annotation>();
            BindingRequest kbr = this.construct(mainFactory, mt.keyType);
            BindingRequest vbr = this.construct(mainFactory, mt.valueType);
            if (kbr == null) {
                kbr = mainFactory.getClass(mt.keyType);
            }
            if (vbr == null) {
                vbr = mainFactory.getClass(mt.valueType);
            }
            if (kbr.getClazz() != null && vbr.getClazz() != null) {
                annotations2.add(new ArgumentImpl(kbr.getClazz(), vbr.getClazz()));
                return new BindingRequest(TreeMap.class, annotations2);
            }
        }
        if (type instanceof StringType) {
            String length;
            String mimetype;
            annotations = new ArrayList();
            StringType st = (StringType)type;
            String pattern = (String)st.metadata.get("pattern");
            if (pattern != null) {
                annotations.add(new PatternImpl(pattern));
            }
            if ((mimetype = (String)st.metadata.get("mimeType")) != null) {
                annotations.add(new MIMETypeImpl(mimetype));
            }
            if ((length = (String)st.metadata.get("length")) != null) {
                annotations.add(new LengthImpl(length));
            }
            return new BindingRequest(String.class, annotations);
        }
        if (type instanceof NumberType) {
            String range;
            annotations = new ArrayList();
            NumberType nt = (NumberType)type;
            String unit = (String)nt.metadata.get("unit");
            if (unit != null) {
                annotations.add(new UnitImpl(unit));
            }
            if ((range = (String)nt.metadata.get("range")) != null) {
                annotations.add(new RangeImpl(range));
            }
            Class<Number> clazz = null;
            if (type instanceof IntegerType) {
                clazz = Integer.TYPE;
            }
            if (type instanceof ByteType) {
                clazz = Byte.TYPE;
            }
            if (type instanceof LongType) {
                clazz = Long.TYPE;
            }
            if (type instanceof DoubleType) {
                clazz = Double.TYPE;
            }
            if (type instanceof FloatType) {
                clazz = Float.TYPE;
            }
            return new BindingRequest(clazz, annotations);
        }
        if (type instanceof BooleanType) {
            return new BindingRequest(Boolean.TYPE, new Annotation[0]);
        }
        if (type instanceof VariantType) {
            return new BindingRequest(Variant.class, new Annotation[0]);
        }
        return null;
    }
}

