/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.selection.ui.handlers;

import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.simantics.Simantics;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.WriteInterface;
import org.simantics.district.selection.ElementSelector;
import org.simantics.district.selection.ui.parts.ElementSelectionView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteElementSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteElementSelector.class);
    @Inject
    EPartService partService;

    @CanExecute
    public boolean canExecute(ESelectionService selectionService) {
        MPart part = this.partService.getActivePart();
        if (part == null) {
            return false;
        }
        Object object = part.getObject();
        if (object == null || !(object instanceof ElementSelectionView)) {
            return false;
        }
        ElementSelectionView view = (ElementSelectionView)object;
        return view.getSelectedItem() != null;
    }

    @Execute
    public void editElementSelector(IEclipseContext context, IWorkbench workbench) {
        MPart part = this.partService.getActivePart();
        if (part == null) {
            return;
        }
        Object object = part.getObject();
        if (object == null || !(object instanceof ElementSelectionView)) {
            return;
        }
        ElementSelectionView view = (ElementSelectionView)object;
        final ElementSelector selectedItem = view.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        Simantics.getSession().async((WriteInterface)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                graph.deny(selectedItem.getResource());
            }
        });
    }
}

