package org.simantics.structural2.queries;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;

public class ConnectionComponents extends ResourceRead<Collection<Resource>> {

	public ConnectionComponents(Resource connection) {
		super(connection);
	}
	
	@Override
	public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
    	ConnectionSet cs = new ConnectionSet(graph);
    	cs.addConnection(graph, resource);
    	return cs.getConnections();
	}
	
}