/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.utils;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Arrays;

public final class GridUtils {
    private static double[] gridLineEvenSpacings = new double[]{1.0, 2.0, 5.0, 10.0};

    public static double getEvenGridSpacing(double value, double gridSize, boolean lessThan) {
        double exp = Math.floor(Math.log10(value));
        double gs = Math.pow(10.0, exp) * gridSize;
        int i = lessThan ? 1 : 0;
        int max = lessThan ? gridLineEvenSpacings.length : gridLineEvenSpacings.length - 1;
        while (i < max) {
            if (gridLineEvenSpacings[i] * gs >= value) {
                if (!lessThan) break;
                --i;
                break;
            }
            ++i;
        }
        if (i >= gridLineEvenSpacings.length) {
            return 2.0 * gridLineEvenSpacings[gridLineEvenSpacings.length - 1] * gs;
        }
        return gridLineEvenSpacings[i] * gs;
    }

    public static double getEvenGridSpacing(double value, boolean lessThan) {
        return GridUtils.getEvenGridSpacing(value, 1.0, lessThan);
    }

    public static double[] getEvenGridSpacingWithExp(double value, double[] array) {
        if (array == null) {
            throw new NullPointerException("null array");
        }
        if (array.length < 2) {
            throw new NullPointerException("");
        }
        double sig = Math.signum(value);
        double exp = Math.floor(Math.log10(Math.abs(value)));
        double gs = Math.pow(10.0, exp);
        int i = 0;
        while (i < gridLineEvenSpacings.length - 1) {
            if (gridLineEvenSpacings[i] * gs >= value) break;
            ++i;
        }
        array[0] = gridLineEvenSpacings[i] * gs * sig;
        array[1] = exp;
        return array;
    }

    public static double[] getEvenGridSpacingWithExp(double value) {
        return GridUtils.getEvenGridSpacingWithExp(value, new double[2]);
    }

    public static double distanceToNextGridCoord(double fromCoord, double gridSpacing) {
        double mod = Math.IEEEremainder(fromCoord, gridSpacing);
        if (mod < 0.0) {
            return -mod;
        }
        if (mod > 0.0) {
            return gridSpacing - mod;
        }
        return 0.0;
    }

    public static double distanceToPrevGridCoord(double fromCoord, double gridSpacing) {
        double mod = Math.IEEEremainder(fromCoord, gridSpacing);
        if (mod < 0.0) {
            return gridSpacing + mod;
        }
        if (mod > 0.0) {
            return mod;
        }
        return 0.0;
    }

    public static double distanceToNextGridCoordScaled(double coord, double gridSpacing, double scale) {
        double result = GridUtils.distanceToNextGridCoord(coord, gridSpacing);
        return result * scale;
    }

    public static double distanceToPrevGridCoordScaled(double coord, double gridSpacing, double scale) {
        double result = GridUtils.distanceToPrevGridCoord(coord, gridSpacing);
        return result * scale;
    }

    public static double distanceToNearestGridCoord(double coord, double gridSpacing) {
        double dist = GridUtils.distanceToNextGridCoord(coord, gridSpacing);
        if (dist > gridSpacing / 2.0) {
            dist -= gridSpacing;
        }
        return dist;
    }

    public static void snapToGrid(AffineTransform tr, double gridSpacing) {
        double gdx = GridUtils.distanceToNearestGridCoord(tr.getTranslateX(), gridSpacing);
        double gdy = GridUtils.distanceToNearestGridCoord(tr.getTranslateY(), gridSpacing);
        tr.translate(gdx, gdy);
    }

    public static void snapToGrid(Point2D p, double gridSpacing) {
        GridUtils.snapToGrid(p, gridSpacing, gridSpacing);
    }

    public static void snapToGrid(Point2D p, double gridXSpacing, double gridYSpacing) {
        double x = p.getX();
        double y = p.getY();
        double gdx = GridUtils.distanceToNearestGridCoord(x, gridXSpacing);
        double gdy = GridUtils.distanceToNearestGridCoord(y, gridYSpacing);
        p.setLocation(x + gdx, y + gdy);
    }

    public static double snapToGrid(double t, double gridSpacing) {
        double dt = GridUtils.distanceToNearestGridCoord(t, gridSpacing);
        return t + dt;
    }

    public static double limitedEvenGridSpacing(double initialValue, double scale, double limit, double gridSize, boolean lessThan) {
        while (initialValue * scale > limit) {
            initialValue /= 2.0;
        }
        return GridUtils.getEvenGridSpacing(initialValue, gridSize, lessThan);
    }

    public static double limitedEvenGridSpacing(double initialValue, double scale, double limit, boolean lessThan) {
        return GridUtils.limitedEvenGridSpacing(initialValue, scale, limit, 1.0, lessThan);
    }

    public static void main(String[] args) {
        System.out.println(Arrays.toString(GridUtils.getEvenGridSpacingWithExp(15.0)));
        System.out.println(Arrays.toString(GridUtils.getEvenGridSpacingWithExp(16.3)));
        System.out.println(Arrays.toString(GridUtils.getEvenGridSpacingWithExp(143.41)));
        System.out.println(Arrays.toString(GridUtils.getEvenGridSpacingWithExp(500.0)));
        System.out.println(Arrays.toString(GridUtils.getEvenGridSpacingWithExp(10000.0)));
        System.out.println(Arrays.toString(GridUtils.getEvenGridSpacingWithExp(0.5)));
        System.out.println(GridUtils.getEvenGridSpacing(15.0, true));
        System.out.println(GridUtils.getEvenGridSpacing(15.0, false));
        System.out.println(GridUtils.getEvenGridSpacing(16.3, true));
        System.out.println(GridUtils.getEvenGridSpacing(16.3, false));
        System.out.println(GridUtils.getEvenGridSpacing(143.41, true));
        System.out.println(GridUtils.getEvenGridSpacing(143.41, false));
        System.out.println(GridUtils.getEvenGridSpacing(500.0, true));
        System.out.println(GridUtils.getEvenGridSpacing(500.0, false));
        System.out.println(GridUtils.getEvenGridSpacing(10000.0, true));
        System.out.println(GridUtils.getEvenGridSpacing(10000.0, false));
        System.out.println(GridUtils.getEvenGridSpacing(0.5, true));
        System.out.println(GridUtils.getEvenGridSpacing(0.5, false));
        System.out.println(GridUtils.getEvenGridSpacing(0.045, true));
        System.out.println(GridUtils.getEvenGridSpacing(0.045, false));
        System.out.println(GridUtils.getEvenGridSpacing(6.05E-4, true));
        System.out.println(GridUtils.getEvenGridSpacing(6.05E-4, false));
        System.out.println(GridUtils.getEvenGridSpacing(143.0, 2.54, true));
        System.out.println(GridUtils.getEvenGridSpacing(143.0, 2.54, false));
    }
}

