/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Set;

import javax.swing.JToggleButton;

import org.simantics.scenegraph.utils.DummyComponent;

public class JBooleanToggleValueNode extends ComponentNode<JToggleButton> implements ActionListener {
    /**
	 * 
	 */
	private static final long serialVersionUID = 3255791584573492072L;

	protected static final BasicStroke STROKE = new BasicStroke(1.0f);
    protected static final Rectangle2D BOUNDS = new Rectangle2D.Double(-10, -10, 20, 20);

    protected Boolean value = null;
    protected transient Set<ActionListener> actionListeners = new HashSet<ActionListener>();

    @SyncField("value")
    public void setValue(Boolean value) {
    	this.value = value;
    	if(component instanceof JToggleButton) {
    		((JToggleButton)component).setSelected(value == null ? false : value);
    	}
    }
    
    @SyncField("transform")
    public void setTransform(AffineTransform transform) {
        assert(transform != null);
        this.transform = transform;
        this.transform.translate(-10, -10);
    }

    @Override
    public void render(Graphics2D g2d) {
        if (component != null) {
        	int width = (int)BOUNDS.getWidth();
        	int height = (int)BOUNDS.getHeight();
        	
        	AffineTransform ot = g2d.getTransform();
        	double sx = 1;
        	double sy = 1;
            if(transform != null) {
                g2d.transform(transform);
                sx = g2d.getTransform().getScaleX();
                sy = g2d.getTransform().getScaleY();
                g2d.scale(1/sx, 1/sy);
            }
            component.setSize((int)(width*sx), (int)(height*sy));
        	component.paint(g2d);
        	
        	g2d.setTransform(ot);
        }
    }
    
    /**
     * Helper method to be used inside MonitorClass
     * @return
     */
    public static Shape getOutline() {
        return BOUNDS;
    }
    
	@Override
	public Rectangle2D getBoundsInLocal() {
		return BOUNDS;
	}

	/**
	 * ClientSide method for handling event and transforming it
	 * NOTE: This is just a wrapper method
	 */
	@Override
	public void actionPerformed(ActionEvent e) {
		Boolean s = component.isSelected();
		performAction(new ActionEvent(new DummyComponent(), ActionEvent.ACTION_PERFORMED, ""+s));
	}
	
	/**
	 * ServerSide method for calling the actionlisteners
	 * @param e
	 */
    @ServerSide
    protected void performAction(ActionEvent e) {
		for(ActionListener listener : actionListeners)
			listener.actionPerformed(e);
    }
	
    public void addActionListener(ActionListener l) {
    	actionListeners.add(l);
    }
    
    public void removeActionListener(ActionListener l) {
    	actionListeners.remove(l);
    }
    
    @Override
    public void init() {
    	Boolean s = value == null ? false : value;
        component = new JToggleButton(null, null, s);
        component.setCursor(new Cursor(Cursor.HAND_CURSOR));
        component.addActionListener(this);
        component.setBackground(Color.RED);
        super.init();
    }
}
