package org.simantics.scenegraph.profile.common;

import org.simantics.db.common.utils.Logger;
import org.simantics.db.procedure.Listener;
import org.simantics.scenegraph.profile.Group;
import org.simantics.scenegraph.profile.Observer;

/**
 * @author Tuukka Lehtonen
 */
public abstract class ObserverGroupValueListener<T> implements Listener<T> {

    protected ObserverGroupListener listener;
    protected Observer              observer;
    protected Group                 group;
    protected Object                data;

    public ObserverGroupValueListener(ObserverGroupListener listener, Observer observer, Group group, Object data) {
        this.listener = listener;
        this.observer = observer;
        this.group = group;
        this.data = data;
    }

    @Override
    public void exception(Throwable t) {
        Logger.defaultLogError(t);
    }

    @Override
    public boolean isDisposed() {
        return listener.isDisposed();
    }

    @Override
    public int hashCode() {
        return listener.hashCode() + 31 * data.hashCode();
//        return observer.hashCode() + 31 * group.hashCode() + 41*data.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        ObserverGroupValueListener<?> other = (ObserverGroupValueListener<?>) object;
        return listener.equals(other.listener) && data.equals(other.data);
//        return observer.equals(other.observer) && group.equals(other.group) && data.equals(other.data);
    }

}
