/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.profile;

/**
 * Diagram profile observer interface is a channel for {@link ProfileEntry} and
 * {@link Style} to request style re-application, log exceptions and track the
 * current state of the profile system for a particular diagram instance.
 * 
 * TODO: add mechanism for partial style re-application
 */
public interface Observer {

    /**
     * Notifies this profile system instance that a profile subsystem is
     * requesting for style re-application for the whole diagram.
     */
    void update();
    
    /**
     * Notifies this profile system instance that a profile subsystem is
     * requesting for style re-application for the given item.
     */
    void update(Style style, Object item);

    /**
     * For logging exceptional situations that occur within profile entries or
     * styles.
     * 
     * @param throwable
     */
    void exception(Throwable throwable);

    /**
     * @return <code>true</code> if this profile system instance has been shut
     *         down, <code>false</code> otherwise
     */
    boolean isDisposed();

}
