/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.sharedontology.wizard;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.simantics.Simantics;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.db.RequestProcessor;
import org.simantics.db.exception.DatabaseException;
import org.simantics.graph.refactoring.FixExportedOntology;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.ui.sharedontology.wizard.ExportPlan;
import org.simantics.modeling.utils.DumpOntologyStructure;
import org.simantics.utils.ui.dialogs.ShowMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedOntologyExporter
implements IRunnableWithProgress {
    private static final Logger LOGGER = LoggerFactory.getLogger(SharedOntologyExporter.class);
    ExportPlan exportModel;

    public SharedOntologyExporter(ExportPlan exportModel) {
        this.exportModel = exportModel;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)50);
        try {
            try {
                this.exportModel(progress.newChild(50, 0));
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            catch (DatabaseException e) {
                throw new InvocationTargetException(e);
            }
            catch (BindingException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    void exportModel(SubMonitor mon) throws IOException, DatabaseException, SerializationException, BindingException {
        try {
            try {
                SharedOntologyExporter.doExport((IProgressMonitor)mon, this.exportModel.exportLocation, this.exportModel.model, this.exportModel.writeTransferableGraph, this.exportModel.dumpStructure);
            }
            catch (DatabaseException e) {
                LOGGER.error("Failed to export shared ontology", (Throwable)e);
                mon.setCanceled(true);
                ShowMessage.showError((String)"Export failed.", (String)"Internal application error in export. See log for details.");
                mon.setWorkRemaining(0);
            }
        }
        finally {
            mon.setWorkRemaining(0);
        }
    }

    public static void doExport(IProgressMonitor monitor, File location, ModelingUtils.LibraryInfo info) throws DatabaseException, IOException {
        SharedOntologyExporter.doExport(monitor, location, info, false, false);
    }

    public static void doExport(IProgressMonitor monitor, File location, ModelingUtils.LibraryInfo info, boolean writeTg, boolean dumpStructure) throws DatabaseException, IOException {
        int work = 1 + (writeTg ? 1 : 0) + (dumpStructure ? 1 : 0);
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)work);
        ModelingUtils.exportSharedOntology((IProgressMonitor)mon.split(1, 0), (RequestProcessor)Simantics.getSession(), (File)location, (String)"sharedLibrary", (int)1, (ModelingUtils.LibraryInfo)info);
        Path input = location.toPath();
        if (writeTg) {
            try {
                mon.subTask("Writing transferable graph");
                FixExportedOntology.createTGAndPGraph((Path)input, (boolean)false);
                mon.worked(1);
            }
            catch (Exception e) {
                LOGGER.error("Could not generate Transferable Graph", (Throwable)e);
            }
        }
        if (dumpStructure) {
            try {
                monitor.subTask("Dumping library structure");
                DumpOntologyStructure data = (DumpOntologyStructure)Simantics.getSession().syncRequest(graph -> new DumpOntologyStructure().read(graph, libraryInfo.library.getResource()));
                data.write(new File(new File(location.getParent(), String.valueOf(location.getName()) + ".dump"), info.library.getName()));
                mon.worked(1);
            }
            catch (Exception e) {
                LOGGER.error("Could not generate shared library structure dump", (Throwable)e);
            }
        }
    }
}

