/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import java.util.function.Supplier;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.combinations.Combinators;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.componentTypeEditor.ComponentTypeScriptDocumentProvider;
import org.simantics.modeling.ui.componentTypeEditor.SCLModuleEditor;
import org.simantics.scl.ui.editor.SCLSourceViewerConfigurationNew;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.scl.ComponentTypeScriptPhaseContribution;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.TitleUpdater;
import org.simantics.ui.workbench.ToolTipRequest;
import org.simantics.utils.ui.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentTypeScriptEditor
extends SCLModuleEditor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentTypeScriptEditor.class);
    protected ComponentTypeScriptDocumentProvider docProvider;
    protected ComponentTypeScriptPhaseContribution.Phase[] phases;
    protected String scriptType = "";
    protected int scriptTypeIndex = 0;
    private static final ComponentTypeScriptPhaseContribution.Phase[] DEFAULT_EXECUTION_PHASES = new ComponentTypeScriptPhaseContribution.Phase[0];

    @Override
    protected void preInitialize() {
        this.docProvider = new ComponentTypeScriptDocumentProvider(this);
        this.setDocumentProvider((IDocumentProvider)this.docProvider);
        SCLSourceViewerConfigurationNew sourceViewerConfiguration = new SCLSourceViewerConfigurationNew((ResourceManager)this.resourceManager);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)sourceViewerConfiguration);
    }

    @Override
    protected ParametrizedRead<IResourceEditorInput, Boolean> getInputValidator() {
        return param -> Combinators.constant((Object)Boolean.TRUE);
    }

    @Override
    protected void updatePartName() {
        this.setPartName(this.getEditorInput().getName());
        Session session = Simantics.peekSession();
        if (session != null) {
            Supplier<Boolean> disposedCallback = this::isDisposed;
            session.asyncRequest((Read)new UniqueRead<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                    Resource script = ComponentTypeScriptEditor.this.getResourceInput().getResource();
                    String name = (String)graph.getRelatedValue(script, L0.HasName);
                    Resource componentType = graph.getSingleObject(script, STR.ComponentType_hasScript_Inverse);
                    String ctName = (String)graph.getRelatedValue(componentType, L0.HasName);
                    return String.valueOf(ctName) + " " + name;
                }
            }, (Listener)new TitleUpdater(this.getSite().getShell().getDisplay(), arg_0 -> ((ComponentTypeScriptEditor)this).setPartName(arg_0), disposedCallback));
            session.asyncRequest((Read)new ToolTipRequest(this.getSite().getId(), this.getResourceInput()), (Listener)new TitleUpdater(this.getSite().getShell().getDisplay(), arg_0 -> ((ComponentTypeScriptEditor)this).setTitleToolTip(arg_0), disposedCallback));
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        Session session = Simantics.peekSession();
        final Resource script = this.getResourceInput().getResource();
        this.phases = this.getPhases(session, script);
        final CCombo combo = new CCombo(parent, 2056);
        ComponentTypeScriptPhaseContribution.Phase[] phaseArray = this.phases;
        int n = this.phases.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentTypeScriptPhaseContribution.Phase p = phaseArray[n2];
            combo.add(p.label);
            ++n2;
        }
        if (session != null) {
            session.asyncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                    String type = (String)graph.getPossibleRelatedValue(script, STR.ComponentTypeScript_type);
                    if (type != null) {
                        ComponentTypeScriptEditor.this.scriptType = type;
                    }
                    combo.getDisplay().asyncExec(() -> {
                        int i = 0;
                        while (i < ComponentTypeScriptEditor.this.phases.length) {
                            if (ComponentTypeScriptEditor.this.phases[i].id.equals(type)) {
                                combo.select(i);
                                ComponentTypeScriptEditor.this.scriptTypeIndex = i;
                                return;
                            }
                            ++i;
                        }
                    });
                }
            });
        }
        combo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            int id = combo.getSelectionIndex();
            if (id == this.scriptTypeIndex) {
                return;
            }
            if (this.docProvider.isReadOnly(this.getEditorInput())) {
                combo.select(this.scriptTypeIndex);
                return;
            }
            ComponentTypeScriptPhaseContribution.Phase newPhase = this.phases[id];
            Simantics.getSession().asyncRequest(graph -> {
                StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                String currentType = (String)graph.getPossibleRelatedValue(script, STR.ComponentTypeScript_type);
                if (!phase.id.equals(currentType)) {
                    graph.claimLiteral(script, STR.ComponentTypeScript_type, (Object)phase.id, (Binding)Bindings.STRING);
                }
            }, exc -> {
                if (exc == null) {
                    this.scriptType = phase.id;
                    this.scriptTypeIndex = id;
                } else {
                    ExceptionUtils.logError((Throwable)exc);
                }
            });
        }));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)combo);
        Composite editorComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)editorComposite);
        editorComposite.setLayout((Layout)new FillLayout());
        super.createPartControl(editorComposite);
    }

    protected ComponentTypeScriptPhaseContribution.Phase[] getPhases(Session session, Resource script) {
        try {
            ComponentTypeScriptPhaseContribution.Phase[] phases = ComponentTypeScriptPhaseContribution.getPhasesForScript((RequestProcessor)session, (Resource)script);
            return phases != null ? phases : DEFAULT_EXECUTION_PHASES;
        }
        catch (DatabaseException ex) {
            LOGGER.error("Failed to get ComponentTypeScriptPhaseContributions for input {}", (Object)script, (Object)ex);
            return DEFAULT_EXECUTION_PHASES;
        }
    }
}

