/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.typicals.rules;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.modeling.typicals.ITypicalSynchronizationRule;
import org.simantics.modeling.typicals.TypicalInfo;
import org.simantics.operation.Layer0X;

/**
 * Synchronizes:
 * * HasMonitorSuffix
 * * Visual attributes: alignments, font, format text, colors
 * 
 * @author Tuukka Lehtonen
 */
public enum MonitorRule implements ITypicalSynchronizationRule {

    INSTANCE;

    public static MonitorRule getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean synchronize(WriteGraph graph, Resource template, Resource instance, TypicalInfo info) throws DatabaseException {
    	
    	Layer0X L0X = Layer0X.getInstance(graph);
        DiagramResource DIA = DiagramResource.getInstance(graph);
        G2DResource G2D = G2DResource.getInstance(graph);

        // TODO consider making sure HasMonitorComponent is up-to-date also even though users should not be able to modify it

        boolean changed = false;
        boolean result = changed |= Properties.synchronizePrimitivePropertyValue(graph, template, instance, DIA.HasMonitorSuffix);
    	if(result) info.messageLog.add("\t\t\tmonitor suffix => " + graph.getPossibleRelatedValue(instance, DIA.HasMonitorSuffix));
        changed |= result;

        result = Properties.synchronizeEnumerationPropertyValue(graph, template, instance, L0X.ObtainsProperty1);
    	if(result) info.messageLog.add("\t\t\tmonitor template => " + NameUtils.getSafeName(graph, graph.getPossibleObject(instance, L0X.ObtainsProperty1)));
        changed |= result;

        result = Properties.synchronizePrimitivePropertyValue(graph, template, instance, G2D.HasBounds);
    	if(result) info.messageLog.add("\t\t\tmonitor bounds => " + graph.getPossibleRelatedValue(instance, G2D.HasBounds));
        changed |= result;
        
        result = Properties.synchronizeDeepPropertyValue(graph, template, instance, DIA.HasColor);
    	if(result) info.messageLog.add("\t\t\tmonitor color");
        changed |= result;
        
        result = Properties.synchronizeDeepPropertyValue(graph, template, instance, DIA.HasFont);
    	if(result) info.messageLog.add("\t\t\tmonitor font");
        changed |= result;

        result = Properties.synchronizeEnumerationPropertyValue(graph, template, instance, DIA.HasFormatter);
    	if(result) info.messageLog.add("\t\t\tmonitor formatter => " + NameUtils.getSafeName(graph, graph.getPossibleObject(instance, DIA.HasFormatter)));
        changed |= result;

        result = Properties.synchronizeEnumerationPropertyValue(graph, template, instance, G2D.HasHorizontalAlignment);
    	if(result) info.messageLog.add("\t\t\tmonitor horizontal alignment => " + NameUtils.getSafeName(graph, graph.getPossibleObject(instance, G2D.HasHorizontalAlignment)));
        changed |= result;
        
        result = Properties.synchronizeEnumerationPropertyValue(graph, template, instance, G2D.HasVerticalAlignment);
    	if(result) info.messageLog.add("\t\t\tmonitor vertical alignment => " + NameUtils.getSafeName(graph, graph.getPossibleObject(instance, G2D.HasVerticalAlignment)));
        changed |= result;

        return changed;
    }

}
