package org.simantics.modeling.predicates;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.layer0.utils.predicates.UnaryTest;
import org.simantics.modeling.utils.Monitors;

public class HasCounterpart extends UnaryTest {

    @Override
    public boolean has(ReadGraph g, Resource resource) throws DatabaseException {
        return FlagUtil.getPossibleCounterpart(g, resource) != null
                || Monitors.getMonitoredElement(g, resource) != null;
    }

}
