/*******************************************************************************
 * Copyright (c) 2020 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy- initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.help;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.PropertyVariables;
import org.simantics.utils.ui.AdaptionUtils;

/**
 * @author Tuukka Lehtonen
 * @since 1.46.0
 */
public class HelpContexts {

    /**
     * @param graph
     * @param resource
     * @param variable
     * @param selection optional <code>ISelection</code> 
     * @return
     * @throws DatabaseException
     */
    public static String getPossibleId(ReadGraph graph, Resource resource, Variable variable, Object selection) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance(graph);
        if (resource != null) {
            Resource component = graph.getPossibleObject(resource, MOD.ElementToComponent);
            String id = component != null ? graph.getPossibleRelatedValue2(component, MOD.contextualHelpId, Bindings.STRING) : null;
            if (id != null)
                return id;
            id = graph.getPossibleRelatedValue2(resource, MOD.contextualHelpId, Bindings.STRING);
            if (id != null)
                return id;
        }

        if (variable != null) {
            String id = variable.getPossiblePropertyValue(graph, MOD.contextualHelpId, Bindings.STRING);
            if (id != null)
                return id;
        }

        // TODO: consider removing this block
        if (selection != null) {
            PropertyVariables vars = AdaptionUtils.adaptToSingle(selection, PropertyVariables.class);
            Variable var = vars != null ? vars.getConfiguration() : null;
            String id = var != null ? var.getPossiblePropertyValue(graph, MOD.contextualHelpId, Bindings.STRING) : null;
            if (id != null)
                return id;
        }

        return null;
    }

    public static String getPossibleId(ReadGraph graph, Variable variable, String property) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance(graph);
        Variable prop = variable != null ? variable.getPossibleProperty(graph, property) : null;
        return prop != null ? prop.getPossiblePropertyValue(graph, MOD.contextualHelpId, Bindings.STRING) : null;
    }

}
