/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.adapters;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.layer0.adapter.impl.TypeSubgraphExtent;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.modeling.ModelingResources;
import org.simantics.operation.Layer0X;

public class MappingSubgraphExtent extends TypeSubgraphExtent {

	final private Classifier classifier = new Classifier() {

		@Override
		public void classify(AsyncReadGraph graph, Statement statement, ExtentStatus objectExtent,
				Callback callback) {

			if(!ExtentStatus.INTERNAL.equals(objectExtent)) return;
			
			Resource predicate = statement.getPredicate();

			Layer0X L0X = graph.getService(Layer0X.class);
			ModelingResources mr = graph.getService(ModelingResources.class);
	
			if(mr.DiagramConnectionToConnection.equalsResource(predicate)) callback.statement(statement, true);
			else if(mr.DiagramToComposite.equalsResource(predicate)) callback.statement(statement, true);
			else if(L0X.HasTrigger.equalsResource(predicate)) callback.statement(statement, true);
			else if(mr.ElementToComponent.equalsResource(predicate)) callback.statement(statement, true);
			else if(mr.CompositeToDiagram.equalsResource(predicate)) callback.statement(statement, true);
			else if(mr.ComponentToElement.equalsResource(predicate)) callback.statement(statement, true);
			else if(mr.ConnectionToDiagramConnection.equalsResource(predicate)) callback.statement(statement, true);
			
		}
		
	};
	
	@Override
	public void accept(AsyncReadGraph graph, Resource resource,
			AsyncProcedure<Classifier> procedure, Callback callback) {
		procedure.execute(graph, classifier);
	}

}
