/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.adapters;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.utils.RemoverUtils;
import org.simantics.modeling.utils.RemoverUtils.ValidationResult;

/**
 * @author Tuukka Lehtonen
 */
public class FlagRemover extends ElementRemover {

    public FlagRemover(Resource flag) {
        super(flag);
    }

    @Override
    public String canRemove(ReadGraph graph, Map<Object, Object> aux) throws DatabaseException {
        boolean lifted = FlagUtil.isLifted(graph, resource);
        if (lifted) {
            ValidationResult result = RemoverUtils.validateFlagRemoval(graph, resource);
            if (result.inUse()) {
                return RemoverUtils.formatError(graph, result);
            }
        }
        return null;
    }

    @Override
    public void remove(WriteGraph graph) throws DatabaseException {
        FlagUtil.disconnectFlag(graph, resource);

        DiagramResource DIA = DiagramResource.getInstance(graph);
        Collection<Resource> connectionRelations = Collections.emptySet();
        if (FlagUtil.isLifted(graph, resource))
            connectionRelations = graph.getObjects(resource, DIA.IsLiftedAs);

        removeElement(graph);

        if (!connectionRelations.isEmpty()) {
            for (Resource connectionRelation : connectionRelations) {
                new ConnectionRelationRemover(connectionRelation).remove(graph);
            }
        }
    }

}
