/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.message;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

/**
 * A more detailed version of {@link IStatus} tailored for Simantics' purposes.
 * 
 * <p>
 * This interface can be used without OSGi running.
 * </p>
 * 
 * @see IStatus
 * @see MultiStatus
 * @see Status
 * 
 * @author Tuukka Lehtonen
 */
public interface IDetailStatus extends IStatus {

    /**
     * Status type severity (bit mask, value 16) indicating this status
     * represents a debug message
     * 
     * @see #getSeverity()
     * @see #matches(int)
     */
    public static final int DEBUG = 0x10;

    /**
     * Returns the message describing the outcome in more detail than the value
     * returned by {@link #getMessage()}. The message is localized to the
     * current locale.
     * 
     * <p>
     * Detailed descriptions messages can should contain additional information
     * regarding the event, such as <code>&lt;a&gt;</code> hyperlinks to
     * resources related to this event. This is necessary to provide a more
     * concrete context for the messages.
     * </p>
     * 
     * @return a localized detailed description
     */
    String getDetailedDescription();

}
