/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.ui.internal;

import java.net.URL;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.simantics.issues.Severity;
import org.simantics.message.IMessageSchemeManager;
import org.simantics.utils.ui.gfx.AlphaAdjustmentImageDescriptor;
import org.simantics.utils.ui.gfx.HSVAdjustmentImageDescriptor;

public class Activator extends AbstractUIPlugin {

    public static final String PLUGIN_ID = "org.simantics.issues.ui"; //$NON-NLS-1$
    
    static Activator instance;
    ServiceTracker   messageScheme;

    public static ImageDescriptor HIDE_ICON;
    public static ImageDescriptor UNHIDE_ICON;
    public static ImageDescriptor RESOLVE_ICON;
    public static ImageDescriptor UNRESOLVE_ICON;

    public static ImageDescriptor PURGE_ICON;

    public static ImageDescriptor FATAL_ICON;
    public static ImageDescriptor ERROR_ICON;
    public static ImageDescriptor WARNING_ICON;
    public static ImageDescriptor INFO_ICON;
    public static ImageDescriptor NOTE_ICON;
    public static ImageDescriptor OK_ICON;

    public static ImageDescriptor FATAL_DECORATION_ICON;
    public static ImageDescriptor ERROR_DECORATION_ICON;
    public static ImageDescriptor WARNING_DECORATION_ICON;
    public static ImageDescriptor INFO_DECORATION_ICON;
    public static ImageDescriptor NOTE_DECORATION_ICON;

    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        messageScheme = new ServiceTracker(context, IMessageSchemeManager.class.getName(), null);

        Bundle bundle = context.getBundle();

        HIDE_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/hide.png")); //$NON-NLS-1$
        UNHIDE_ICON = AlphaAdjustmentImageDescriptor.adjustAlpha(HSVAdjustmentImageDescriptor.adjust(
                HIDE_ICON, 0f, 0f, 1f), 96);
        //RESOLVE_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/lightbulb.png"));
        //UNRESOLVE_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/lightbulb_off.png"));
        RESOLVE_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/tick.png")); //$NON-NLS-1$
        UNRESOLVE_ICON = AlphaAdjustmentImageDescriptor.adjustAlpha(HSVAdjustmentImageDescriptor.adjust(
                RESOLVE_ICON, 0f, 0f, 1f), 96);

        PURGE_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/purge.gif")); //$NON-NLS-1$

        FATAL_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/fatal.png")); //$NON-NLS-1$
        ERROR_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/error.png")); //$NON-NLS-1$
        WARNING_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/warning.png")); //$NON-NLS-1$
        INFO_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/information.png")); //$NON-NLS-1$
        NOTE_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/note.png")); //$NON-NLS-1$
        OK_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/noissue.png")); //$NON-NLS-1$

        FATAL_DECORATION_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/fatal_decoration.png")); //$NON-NLS-1$
        ERROR_DECORATION_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/error_decoration.png")); //$NON-NLS-1$
        WARNING_DECORATION_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/warning_decoration.png")); //$NON-NLS-1$
        INFO_DECORATION_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/information_decoration.png")); //$NON-NLS-1$
        NOTE_DECORATION_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/note_decoration.png")); //$NON-NLS-1$
    }

    @Override
    protected ImageRegistry createImageRegistry() {
        return super.createImageRegistry();
    }

    @Override
    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put(Severity.FATAL.toString()+"-full", FATAL_ICON); //$NON-NLS-1$
        reg.put(Severity.ERROR.toString()+"-full", ERROR_ICON); //$NON-NLS-1$
        reg.put(Severity.WARNING.toString()+"-full", WARNING_ICON); //$NON-NLS-1$
        reg.put(Severity.INFO.toString()+"-full", INFO_ICON); //$NON-NLS-1$
        reg.put(Severity.NOTE.toString()+"-full", NOTE_ICON); //$NON-NLS-1$
        reg.put(Severity.FATAL.toString(), FATAL_DECORATION_ICON);
        reg.put(Severity.ERROR.toString(), ERROR_DECORATION_ICON);
        reg.put(Severity.WARNING.toString(), WARNING_DECORATION_ICON);
        reg.put(Severity.INFO.toString(), INFO_DECORATION_ICON);
        reg.put(Severity.NOTE.toString(), NOTE_DECORATION_ICON);
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        messageScheme.close();
        instance = null;
        super.stop(context);
    }

    /**
     * Returns the shared instance
     *
     * @return the shared instance
     */
    public static Activator getDefault() {
        return instance;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin(PLUGIN_ID, path);
    }

    public static URL getDefaultResource(String name) {
        Activator plugin = getDefault();
        if(plugin == null) throw new IllegalStateException("The plugin is not active."); //$NON-NLS-1$
        Bundle bundle = plugin.getBundle(); 
        return bundle.getResource(name);
    }

}
