/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.image.ui;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.image2.ontology.ImageResource;
import org.simantics.layer0.Layer0;

/**
 * @author Tuukka Lehtonen
 */
public class CreateImage extends WriteRequest {

    private Resource container;
    private ImageSource source;

    public CreateImage(Resource container, ImageSource source) {
        this.container = container;
        this.source = source;
    }

    public static Resource getType(ReadGraph graph, ImageSource source) throws DatabaseException {
    	ImageResource IMAGE = ImageResource.getInstance(graph);
    	String name = source.name.toLowerCase();
    	if(name.endsWith("svg")) return IMAGE.SvgImage; //$NON-NLS-1$
    	else if(name.endsWith("png")) return IMAGE.PngImage; //$NON-NLS-1$
    	else if(name.endsWith("jpg") || name.endsWith("jpeg")) return IMAGE.JpegImage; //$NON-NLS-1$ //$NON-NLS-2$
    	else if(name.endsWith("gif")) return IMAGE.GifImage; //$NON-NLS-1$
    	else throw new DatabaseException("Unsupported image format " + source.name); //$NON-NLS-1$
    }
    
    public static void claimLiteral(WriteGraph graph, Resource image, ImageSource source) throws DatabaseException {
        String name = source.name.toLowerCase();
        if (name.endsWith("svg")) //$NON-NLS-1$
            graph.claimValue(image, new String(source.data), Bindings.STRING);
        else if (name.endsWith("png") || name.endsWith("jpg") || name.endsWith("jpeg") || name.endsWith("gif")) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
            graph.claimValue(image, source.data, Bindings.BYTE_ARRAY);
    	else throw new DatabaseException("Unsupported image format " + source.name); //$NON-NLS-1$
    }

    @Override
    public void perform(WriteGraph graph) throws DatabaseException {
    	doImage(graph, container, source);
    }
    
    public Resource doImage(WriteGraph graph, Resource parent, ImageSource source) throws DatabaseException {
        graph.markUndoPoint();
    	Layer0 L0 = Layer0.getInstance(graph);
    	Resource image = graph.newResource();
    	graph.claim(image, L0.InstanceOf, null, getType(graph, source));
    	graph.claimLiteral(image, L0.HasName, source.name, Bindings.STRING);
    	claimLiteral(graph, image, source);
    	graph.claim(parent, L0.ConsistsOf, image);
    	Layer0Utils.addCommentMetadata(graph, "Imported image " + source.name + " " + image.toString()); //$NON-NLS-1$ //$NON-NLS-2$
    	return image;
    	
//    	if(file.getPath().endsWith("svg")) {
//            ImageSource src = ImportImagesActionFactory.toImageSource(file);
//            Layer0 l0 = Layer0.getInstance(graph);
//            ImageResource img = ImageResource.getInstance(graph);
//            Resource image = graph.newResource();
//            graph.claim(image, l0.InstanceOf, null, img.Image);
//            graph.claimLiteral(image, l0.HasName, src.name, Bindings.STRING);
//            String document = FileUtils.getContents(file.getAbsolutePath());
//            graph.claimLiteral(image, img.HasImageDocument, document, Bindings.STRING);
//            graph.claim(container, l0.ConsistsOf, image);
//            graph.claim(container, img.HasImage, image);
//    	} else {
//    	}
//
//    	
//        Layer0 l0 = Layer0.getInstance(graph);
//        ImageResource img = ImageResource.getInstance(graph);
//
//        Resource image = graph.newResource();
//        graph.claim(image, l0.InstanceOf, null, img.Image);
//        graph.claimLiteral(image, l0.HasName, source.name, Bindings.STRING);
//        graph.claimLiteral(image, img.HasImageData, source.data, Bindings.BYTE_ARRAY);
//        graph.claim(container, l0.ConsistsOf, image);
//        graph.claim(container, img.HasImage, image);
        	
    }

}