/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semamtum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.graph.db;

import java.util.Set;

/**
 * @author Tuukka Lehtonen
 * @since 1.28.0
 */
public class ImportResult {

	/**
	 * This lists externals that the import was missing and has created in the
	 * database as L0.ExternalEntity place-holders for now.
	 */
	public final Set<String> missingExternals;

	public ImportResult(Set<String> missingExternals) {
		this.missingExternals = missingExternals;
	}

	public boolean hasMissingExternals() {
		return !missingExternals.isEmpty();
	}

}
