/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.internal;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.simantics.datatypes.literal.RGB;
import org.simantics.datatypes.literal.Vec2d;
import org.simantics.scl.runtime.function.Function3;
import org.simantics.scl.runtime.function.FunctionImpl3;
import org.simantics.utils.FileUtils;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.simantics.diagram";
    private static Activator plugin;
    public static ImageDescriptor LINK_ICON;
    public static ImageDescriptor LINK_BREAK_ICON;
    private static Map<String, String> iconTexts;
    private static Map<String, String> iconDocumentCache;
    public static Function3<String, RGB.Integer, Vec2d, String> ICON_PROVIDER;

    static {
        iconTexts = new HashMap<String, String>();
        iconDocumentCache = new HashMap<String, String>();
        ICON_PROVIDER = new FunctionImpl3<String, RGB.Integer, Vec2d, String>(){

            private String hex2(int value) {
                String result = Integer.toHexString(value);
                if (result.length() == 1) {
                    result = "0" + result;
                }
                return result;
            }

            private int saturate(int in, double factor) {
                return (int)((double)in + factor * (double)(255 - in));
            }

            private int darken(int in, double factor) {
                return (int)((double)in * factor);
            }

            public String apply(String iconName, RGB.Integer rgb, Vec2d scale) {
                int r = rgb.red;
                int g = rgb.green;
                int b = rgb.blue;
                String base = iconTexts.get(iconName);
                if (base == null) {
                    return null;
                }
                int c4 = (r << 16) + (g << 8) + b;
                String key = String.valueOf(iconName) + c4 + "#" + scale.x + "#" + scale.y;
                String cached = iconDocumentCache.get(key);
                if (cached == null) {
                    int c1 = (this.saturate(r, 0.83) << 16) + (this.saturate(g, 0.83) << 8) + this.saturate(b, 0.83);
                    int c2 = (this.saturate(r, 0.5) << 16) + (this.saturate(g, 0.5) << 8) + this.saturate(b, 0.5);
                    int c3 = (this.saturate(r, 0.16) << 16) + (this.saturate(g, 0.16) << 8) + this.saturate(b, 0.16);
                    int c5 = (this.darken(r, 0.83) << 16) + (this.darken(g, 0.83) << 8) + this.darken(b, 0.83);
                    base = base.replace("!!c1!!", this.hex2(c1));
                    base = base.replace("!!c2!!", this.hex2(c2));
                    base = base.replace("!!c3!!", this.hex2(c3));
                    base = base.replace("!!c4!!", this.hex2(c4));
                    base = base.replace("!!scalex!!", "" + scale.x);
                    base = base.replace("!!scaley!!", "" + scale.y);
                    cached = base.replace("!!c5!!", this.hex2(c5));
                    iconDocumentCache.put(key, cached);
                }
                return cached;
            }
        };
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Bundle bundle = context.getBundle();
        iconTexts.put("LED", FileUtils.getContents((URL)bundle.getResource("icons/IconLed.svg")));
        iconTexts.put("TERMINAL", FileUtils.getContents((URL)bundle.getResource("icons/IconTerminal.svg")));
        iconTexts.put("SQUARE", FileUtils.getContents((URL)bundle.getResource("icons/IconSquare.svg")));
        iconTexts.put("BUTTON_ON", FileUtils.getContents((URL)bundle.getResource("icons/ButtonOn.svg")));
        iconTexts.put("BUTTON_OFF", FileUtils.getContents((URL)bundle.getResource("icons/ButtonOff.svg")));
        LINK_ICON = ImageDescriptor.createFromURL((URL)bundle.getResource("icons/link.png"));
        LINK_BREAK_ICON = ImageDescriptor.createFromURL((URL)bundle.getResource("icons/link_break.png"));
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

