/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.common.color.Color;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.guarded.GuardedAsyncProcedureWrapper;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.diagram.G2DUtils;
import org.simantics.diagram.adapter.ElementFactory;
import org.simantics.diagram.adapter.ElementFactoryUtil;
import org.simantics.diagram.adapter.SyncElementFactory;
import org.simantics.diagram.elements.ElementPropertySetter;
import org.simantics.diagram.elements.MonitorClass;
import org.simantics.diagram.elements.ResizeRectangularSceneGraph;
import org.simantics.diagram.elements.TextElementHandler;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.CompositeHintSynchronizer;
import org.simantics.diagram.synchronization.IHintSynchronizer;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.TextSynchronizer;
import org.simantics.diagram.synchronization.graph.TransformSynchronizer;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.Text;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.element.handler.impl.StaticSymbolImpl;
import org.simantics.g2d.element.handler.impl.TextColorImpl;
import org.simantics.g2d.element.handler.impl.TextFontImpl;
import org.simantics.g2d.image.DefaultImages;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.svg.SVGImage;
import org.simantics.g2d.utils.Alignment;
import org.simantics.ui.colors.Colors;
import org.simantics.ui.fonts.FontDescriptor;
import org.simantics.ui.fonts.Fonts;

public class TextElementClassFactory
extends SyncElementFactory {
    public static final ElementFactory INSTANCE = new TextElementClassFactory();
    public static final IHintSynchronizer TEXT_SYNCHRONIZER = new CompositeHintSynchronizer(TextSynchronizer.INSTANCE, TransformSynchronizer.INSTANCE);
    public static final ElementPropertySetter RESIZE_PROPERTY_SETTER = new ElementPropertySetter(ResizeRectangularSceneGraph.KEY_SG_NODE);

    @Override
    public ElementClass create(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType) throws DatabaseException {
        String id = "TextElement: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)elementType);
        G2DResource g2d = G2DResource.getInstance((ReadGraph)graph);
        String svgDoc = (String)graph.getPossibleRelatedValue(elementType, g2d.HasSVGDocument);
        Object image = null;
        image = svgDoc != null ? new SVGImage(String.valueOf(id) + ".svg", svgDoc) : (Image)DefaultImages.ERROR_DECORATOR.get();
        return ElementClass.compile((ElementHandler[])new ElementHandler[]{Text.INSTANCE, TextColorImpl.BLACK, TextFontImpl.DEFAULT, new StaticObjectAdapter((Object)elementType), DefaultTransform.INSTANCE, SimpleElementLayers.INSTANCE, TextElementHandler.INSTANCE, ResizeRectangularSceneGraph.INSTANCE, RESIZE_PROPERTY_SETTER, new StaticSymbolImpl(image)}).setId(id);
    }

    @Override
    public void load(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource element, IElement e, AsyncProcedure<IElement> procedure) {
        GuardedAsyncProcedureWrapper guard = new GuardedAsyncProcedureWrapper(procedure, 2);
        super.load(graph, canvas, diagram, element, e, (AsyncProcedure<IElement>)guard);
        ElementFactoryUtil.loadLayersForElement(graph, diagram, e, element, (AsyncProcedure<IElement>)guard);
    }

    @Override
    public void load(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource element, IElement e) throws DatabaseException {
        Float borderWidth;
        Resource colorResource;
        Resource fontResource;
        G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        String text = (String)graph.getPossibleRelatedValue(element, DIA.HasText);
        if (text == null) {
            text = ElementUtils.getText((IElement)e);
        }
        if (text == null) {
            text = "[empty]";
        }
        ElementUtils.setText((IElement)e, (String)text);
        FontDescriptor fd = (FontDescriptor)graph.getPossibleRelatedAdapter(element, DIA.HasFont, FontDescriptor.class);
        if (fd != null) {
            ElementUtils.setTextFont((IElement)e, (Font)Fonts.awt((FontDescriptor)fd));
        } else if (graph.isInstanceOf(element, DIA.FontProvider) && (fontResource = graph.getPossibleObject(element, G2D.HasFont)) != null) {
            ElementUtils.setTextFont((IElement)e, (Font)G2DUtils.getFont(graph, fontResource));
        }
        Color color = (Color)graph.getPossibleRelatedAdapter(element, DIA.HasColor, Color.class);
        if (color != null) {
            ElementUtils.setTextColor((IElement)e, (java.awt.Color)Colors.awt((Color)color));
        } else if (graph.isInstanceOf(element, DIA.ColorProvider) && (colorResource = graph.getPossibleObject(element, G2D.HasColor)) != null) {
            ElementUtils.setTextColor((IElement)e, (java.awt.Color)G2DUtils.getColor(graph, colorResource));
        }
        Resource hAlign = graph.getPossibleObject(element, G2D.HasHorizontalAlignment);
        Resource vAlign = graph.getPossibleObject(element, G2D.HasVerticalAlignment);
        if (hAlign != null) {
            e.setHint(ElementHints.KEY_HORIZONTAL_ALIGN, (Object)DiagramGraphUtil.toAlignment(hAlign, G2D, Alignment.LEADING));
        }
        if (vAlign != null) {
            e.setHint(ElementHints.KEY_VERTICAL_ALIGN, (Object)DiagramGraphUtil.toVerticalAlignment(vAlign, G2D, Alignment.BASELINE));
        }
        if ((borderWidth = (Float)graph.getPossibleRelatedValue(element, G2D.HasStrokeWidth)) != null) {
            e.setHint(MonitorClass.KEY_BORDER_WIDTH, (Object)borderWidth.doubleValue());
        }
        AffineTransform at = DiagramGraphUtil.getAffineTransform(graph, element);
        ElementUtils.setTransform((IElement)e, (AffineTransform)at);
        e.setHint(SynchronizationHints.HINT_SYNCHRONIZER, (Object)TEXT_SYNCHRONIZER);
        double[] bounds = DiagramGraphUtil.getPossibleRelatedDoubleArray(graph, element, G2D.HasBounds);
        if (bounds != null) {
            e.setHint(ElementHints.KEY_BOUNDS, (Object)new Rectangle2D.Double(bounds[0], bounds[1], bounds[2], bounds[3]));
        }
    }
}

