/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server.internal;

import org.simantics.db.Database;
import org.simantics.db.exception.SDBException;
import org.simantics.db.server.ProCoreException;
import org.simantics.db.server.internal.Event;
import org.simantics.db.server.internal.EventHandler;
import org.simantics.db.server.internal.Util;
import org.simantics.db.server.protocol.ChangeSetUpdateEvent;

class ChangeSetEventHandler
extends EventHandler
implements Database.Session.ChangeSetUpdate {
    private final ChangeSetUpdateEvent csuEvent = new ChangeSetUpdateEvent();
    private final Database.Session.OnChangeSetUpdate on;
    private ProCoreException exception;

    ChangeSetEventHandler(Database.Session.OnChangeSetUpdate on) {
        this.on = on;
    }

    @Override
    void on(Event event) {
        event.deserialize(this.csuEvent);
        Util.log("ChangeSetEvent cid=" + this.csuEvent.changeSetId);
        try {
            if (this.on != null) {
                this.on.onChangeSetUpdate((Database.Session.ChangeSetUpdate)this);
            }
        }
        catch (SDBException e) {
            if (this.exception == null) {
                this.exception = new ProCoreException("Execution of ChangeSetUpdate callback failed.", e);
            }
            Util.logError("Execution of ChangeSetUpdate callback failed(2).", e);
        }
    }

    public long getChangeSetId() {
        return this.csuEvent.changeSetId;
    }

    public int getChangeSetIndex() {
        return this.csuEvent.changeSetIndex;
    }

    public int getNumberOfClusterChangeSets() {
        return this.csuEvent.numberOfClusterChangeSets;
    }

    public int getIndexOfClusterChangeSet() {
        return this.csuEvent.indexOfClusterChangeSet;
    }

    public byte[] getClusterId() {
        return this.csuEvent.clusterUID;
    }

    public boolean getNewCluster() {
        return this.csuEvent.newCluster;
    }

    public byte[] getData() {
        return this.csuEvent.data;
    }
}

