/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.internal;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;

import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

/**
 * This class works around Eclipse bug #254570 - StructuredSelection is missing
 * {@link #hashCode()} implementation.
 * 
 * <p>
 * Use {@link #wrapSelection(ISelection)} to obtain a wrapper for
 * StructuredSelection instances that "injects" a hashCode implementation.
 * 
 * @author Tuukka Lehtonen
 * @deprecated does not work, do not use, causes problems with DB requests:
 * <pre>
 * Exception in thread "Query Thread 1" java.lang.IllegalArgumentException: Equal objects must have equal hashcodes. During rehashing, Trove discovered that the following two objects claim to be equal (as in java.lang.Object.equals()) but their hashCodes (or those calculated by your TObjectHashingStrategy) are not equal.This violates the general contract of java.lang.Object.hashCode().  See bullet point two in that method's documentation. object #1 =LazyViewpoint[22182778].childQuery; object #2 =LazyViewpoint[2672086].childQuery
 * at org.simantics.db.impl.query.StableObjectHash.throwObjectContractViolation(StableObjectHash.java:348)
 * at org.simantics.db.impl.query.StableHashMap.rehash(StableHashMap.java:410)
 * at gnu.trove.THash.postInsertHook(THash.java:368)
 * at org.simantics.db.impl.query.StableHashMap.doPut(StableHashMap.java:214)
 * at org.simantics.db.impl.query.StableHashMap.put(StableHashMap.java:182)
 * at org.simantics.db.impl.query.QueryProcessor.performForEach(QueryProcessor.java:1433)
 * at org.simantics.db.impl.query.QueryProcessor.runRead(QueryProcessor.java:1020)
 * at org.simantics.db.impl.query.QueryProcessor$4.run(QueryProcessor.java:1178)
 * at org.simantics.db.impl.query.QueryProcessor$1.run(QueryProcessor.java:680)
 * </pre>
 */
@Deprecated
class Bug254570Workaround extends StructuredSelection {

    private final Object[]         elements;
    private final IElementComparer comparer;

    public static ISelection wrapSelection(ISelection s) {
        if (s == null)
            return null;
        try {
            return StructuredSelection.class.equals(s.getClass()) ? Bug254570Workaround.make((StructuredSelection) s) : s;
        } catch (SecurityException e) {
            throw new RuntimeException("Workaround for #254570 failed", e);
        } catch (NoSuchFieldException e) {
            throw new RuntimeException("Workaround for #254570 failed", e);
        } catch (IllegalArgumentException e) {
            throw new RuntimeException("Workaround for #254570 failed", e);
        } catch (IllegalAccessException e) {
            throw new RuntimeException("Workaround for #254570 failed", e);
        }
        //return s;
    }

    public static Bug254570Workaround make(StructuredSelection s) throws SecurityException,
    NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (s == null)
            throw new NullPointerException("null StructuredSelection");

        Class<?> clazz = s.getClass();
        Field elementsField = null;
        Field comparerField = null;
        for (Field f : clazz.getDeclaredFields()) {
            if ("elements".equals(f.getName()))
                elementsField = f;
            else if ("comparer".equals(f.getName()))
                comparerField = f;
        }
        if (elementsField == null)
            throw new IllegalArgumentException("could not find field 'elements'");
        if (comparerField == null)
            throw new IllegalArgumentException("could not find field 'comparer'");

        Object[] elements = getAccessible(elementsField, s);
        IElementComparer comparer = getAccessible(comparerField, s);

        return new Bug254570Workaround(elements, comparer);
    }

    private static <T> T getAccessible(Field f, Object obj) throws IllegalArgumentException, IllegalAccessException {
        boolean accessible = f.isAccessible();
        try {
            if (!accessible)
                f.setAccessible(true);
            @SuppressWarnings("unchecked")
            T t = (T) f.get(obj);
            return t;
        } finally {
            if (!accessible)
                f.setAccessible(false);
        }
    }

    private Bug254570Workaround(Object[] elements, IElementComparer comparer) {
        super(elements == null ? Collections.emptyList() : Arrays.asList(elements), comparer);
        this.elements = elements;
        this.comparer = comparer;
    }

    private int hashCode(Object element) {
        return element == null ? 0 :
            comparer != null ? comparer.hashCode(element) : element.hashCode();
    }

    /**
     * StructuredSelection.hashCode is not implemented, need to implement
     * it here.
     */
    @Override
    public int hashCode() {
        int code = 31;
        if (elements != null) {
            for (int i = 0; i < elements.length; i++) {
                code = code * 17 + hashCode(elements[i]);
            }
        }
        return code;
    }
}