/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.contentassist;

/**
 * @author Tuukka Lehtonen
 */
public class NamedObjectContentProposal implements INamedObjectContentProposal {

    private final NamedObject<?> object;
    private final int         position;

    public NamedObjectContentProposal(NamedObject<?> object, int position) {
        this.object = object;
        this.position = position;
    }

    @Override
    public INamedObject getNamedObject() {
        return object;
    }

    @SuppressWarnings("unchecked")
    public <T> T getObject() {
        return (T) object.getObject();
    }

    @Override
    public String getContent() {
        return object.getName().substring(position);
    }

    @Override
    public int getCursorPosition() {
        return object.getName().length();
    }

    @Override
    public String getLabel() {
        return object.getLabel();
    }

    @Override
    public String getDescription() {
        return object.getDescription();
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "[" + object.toString() + "]";
    }

}
