/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.util.Collections;
import java.util.Set;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeContext.PrimitiveQueryKey;
import org.simantics.browsing.ui.graph.impl.CommonKeys;
import org.simantics.browsing.ui.graph.impl.LazyGraphQueryProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.Container;

public class TypesQueryProcessor extends LazyGraphQueryProcessor<Set<Resource>> {

    @Override
    public String toString() {
        return "Types";
    }

    @Override
    public Object getIdentifier() {
        return CommonKeys.TYPES;
    }

    @Override
    protected Set<Resource> initial() {
        return Collections.emptySet();
    }

    @Override
    protected Set<Resource> compute(ReadGraph graph, NodeContext context, PrimitiveQueryKey<Container<Set<Resource>>> key) throws DatabaseException {
        Object input = context.getConstant(BuiltinKeys.INPUT);
        Resource resource = ResourceAdaptionUtils.toSingleResource(input);
        if(resource != null) {
            return graph.getTypes(resource);
        } else {
            return Collections.emptySet();
        }
    }

}
