/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.util.Collection;

import org.eclipse.swt.graphics.Image;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeContext.QueryKey;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.common.imagers.ImageURLs;
import org.simantics.browsing.ui.common.processors.AbstractNodeQueryProcessor;
import org.simantics.browsing.ui.content.Imager;
import org.simantics.browsing.ui.content.ImagerFactory;

public class DefaultSelectedImagerProcessor extends AbstractNodeQueryProcessor<Imager> {

    public DefaultSelectedImagerProcessor() {
    }

    @Override
    public QueryKey<Imager> getIdentifier() {
        return BuiltinKeys.SELECTED_IMAGER;
    }

    @Override
    public Imager query(NodeQueryManager manager, NodeContext context) {

        Collection<ImagerFactory> imagers = manager.query(context, BuiltinKeys.IMAGER_FACTORIES);
        if (imagers.isEmpty()) {

            Imager imager = (Imager) context.getAdapter(Imager.class);
            if (imager != null)
                return imager;
            ImageURLs urls = (ImageURLs) context.getAdapter(ImageURLs.class);
            if (urls != null) {
                return new ImageURLsImager<Image>(urls);
            } else {
                return new NullImager();
            }
        }

        // TODO: use SelectedLabelerFactory query instead of this educated choice
        ImagerFactory factory = imagers.iterator().next();

        return manager.query(context, new BuiltinKeys.ImagerKey(factory));

    }

    @Override
    public String toString() {
        return "SelectedLabelerProcessor";
    }

}