/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.gizmo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.osgi.framework.Bundle;
import org.simantics.g3d.scenegraph.RenderListener;
import org.simantics.g3d.tools.PluginTools;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.g3d.vtk.gizmo.vtkGizmo;
import org.simantics.g3d.vtk.utils.vtkUtil;
import org.simantics.plant3d.Activator;
import org.simantics.plant3d.scenegraph.PipelineComponent;
import org.simantics.plant3d.scenegraph.controlpoint.PipeControlPoint;
import vtk.vtkCell;
import vtk.vtkCellArray;
import vtk.vtkDataArray;
import vtk.vtkFloatArray;
import vtk.vtkMapper2D;
import vtk.vtkPNGReader;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper2D;
import vtk.vtkPolygon;
import vtk.vtkProp;
import vtk.vtkRenderer;
import vtk.vtkTexture;
import vtk.vtkTexturedActor2D;

public class TerminalSelectionGizmo
extends vtkGizmo {
    vtkTexturedActor2D prevProp;
    vtkTexturedActor2D nextProp;
    vtkTexturedActor2D middleProp;
    boolean showPrev = false;
    boolean showNext = false;
    boolean showMiddle = false;
    Vector3d middle = new Vector3d();
    Vector3d prev = new Vector3d();
    Vector3d next = new Vector3d();
    VtkView panel;
    private RenderListener listener;

    public TerminalSelectionGizmo(VtkView panel) {
        this.panel = panel;
        this.listener = new RenderListener(){

            public void preRender() {
                Point2d p;
                if (TerminalSelectionGizmo.this.showMiddle) {
                    p = vtkUtil.getScreenCoordinates((vtkRenderer)TerminalSelectionGizmo.this.getRenderer(), (Tuple3d)TerminalSelectionGizmo.this.middle);
                    TerminalSelectionGizmo.this.middleProp.SetDisplayPosition((int)p.x, (int)p.y);
                }
                if (TerminalSelectionGizmo.this.showPrev) {
                    p = vtkUtil.getScreenCoordinates((vtkRenderer)TerminalSelectionGizmo.this.getRenderer(), (Tuple3d)TerminalSelectionGizmo.this.prev);
                    TerminalSelectionGizmo.this.prevProp.SetDisplayPosition((int)p.x, (int)p.y);
                }
                if (TerminalSelectionGizmo.this.showNext) {
                    p = vtkUtil.getScreenCoordinates((vtkRenderer)TerminalSelectionGizmo.this.getRenderer(), (Tuple3d)TerminalSelectionGizmo.this.next);
                    TerminalSelectionGizmo.this.nextProp.SetDisplayPosition((int)p.x, (int)p.y);
                }
            }

            public void postRender() {
            }
        };
    }

    vtkRenderer getRenderer() {
        return this.panel.getRenderer();
    }

    public void attach(VtkView renderingPart) {
        if (this.nextProp == null) {
            this.loadData();
        }
        this.panel.addListener(this.listener);
        super.attach(renderingPart);
    }

    public Collection<vtkProp> getGizmo() {
        ArrayList<vtkProp> list = new ArrayList<vtkProp>();
        if (this.showPrev) {
            list.add((vtkProp)this.prevProp);
        }
        if (this.showNext) {
            list.add((vtkProp)this.nextProp);
        }
        if (this.showMiddle) {
            list.add((vtkProp)this.middleProp);
        }
        return list;
    }

    protected void attachActors() {
        this.panel.lock();
        vtkRenderer ren = this.getRenderer();
        if (this.showPrev) {
            ren.AddActor2D((vtkProp)this.prevProp);
        }
        if (this.showNext) {
            ren.AddActor2D((vtkProp)this.nextProp);
        }
        if (this.showMiddle) {
            ren.AddActor2D((vtkProp)this.middleProp);
        }
        this.panel.unlock();
    }

    protected void deattachActors() {
        this.panel.removeListener(this.listener);
        this.panel.lock();
        vtkRenderer ren = this.getRenderer();
        ren.RemoveActor((vtkProp)this.prevProp);
        ren.RemoveActor((vtkProp)this.nextProp);
        ren.RemoveActor((vtkProp)this.middleProp);
        this.panel.unlock();
    }

    public void setComponent(PipelineComponent component, Set<PipeControlPoint.PositionType> allowed) {
        this.showPrev = allowed.contains((Object)PipeControlPoint.PositionType.PREVIOUS);
        this.showNext = allowed.contains((Object)PipeControlPoint.PositionType.NEXT);
        this.showMiddle = allowed.contains((Object)PipeControlPoint.PositionType.SPLIT);
        this.middle = component.getControlPoint().getWorldPosition();
        component.getControlPoint().getControlPointEnds((Tuple3d)this.prev, (Tuple3d)this.next);
    }

    private void loadData() {
        String middleTexFile = PluginTools.getAbsolutePath((Bundle)Activator.getDefault().getBundle(), (String)"icons/middle.png");
        String plusTexFile = PluginTools.getAbsolutePath((Bundle)Activator.getDefault().getBundle(), (String)"icons/plus.png");
        if (middleTexFile == null || plusTexFile == null) {
            throw new RuntimeException("Cannot resolve required image files.");
        }
        vtkPoints points = new vtkPoints();
        double pw = 8.0;
        points.InsertNextPoint(-pw, -pw, 0.0);
        points.InsertNextPoint(pw, -pw, 0.0);
        points.InsertNextPoint(pw, pw, 0.0);
        points.InsertNextPoint(-pw, pw, 0.0);
        vtkCellArray cellArray = new vtkCellArray();
        vtkPolygon polygon = new vtkPolygon();
        polygon.GetPointIds().SetNumberOfIds(4);
        polygon.GetPointIds().SetId(0, 0);
        polygon.GetPointIds().SetId(1, 1);
        polygon.GetPointIds().SetId(2, 2);
        polygon.GetPointIds().SetId(3, 3);
        cellArray.InsertNextCell((vtkCell)polygon);
        vtkPolyData quad = new vtkPolyData();
        quad.SetPoints(points);
        quad.SetPolys(cellArray);
        vtkFloatArray texCoords = new vtkFloatArray();
        texCoords.SetNumberOfComponents(2);
        texCoords.InsertNextTuple2(0.0, 0.0);
        texCoords.InsertNextTuple2(1.0, 0.0);
        texCoords.InsertNextTuple2(1.0, 1.0);
        texCoords.InsertNextTuple2(0.0, 1.0);
        quad.GetPointData().SetTCoords((vtkDataArray)texCoords);
        vtkPNGReader middleReader = new vtkPNGReader();
        middleReader.SetFileName(middleTexFile);
        vtkPNGReader plusReader = new vtkPNGReader();
        plusReader.SetFileName(plusTexFile);
        vtkTexture middleTex = new vtkTexture();
        middleTex.SetInputConnection(middleReader.GetOutputPort());
        middleTex.SetInterpolate(1);
        vtkTexture plusTex = new vtkTexture();
        plusTex.SetInputConnection(plusReader.GetOutputPort());
        plusTex.SetInterpolate(1);
        vtkPolyDataMapper2D mapper = new vtkPolyDataMapper2D();
        mapper.SetInputData(quad);
        this.nextProp = new vtkTexturedActor2D();
        this.prevProp = new vtkTexturedActor2D();
        this.middleProp = new vtkTexturedActor2D();
        this.nextProp.SetMapper((vtkMapper2D)mapper);
        this.nextProp.SetTexture(plusTex);
        this.nextProp.SetPickable(1);
        this.prevProp.SetMapper((vtkMapper2D)mapper);
        this.prevProp.SetTexture(plusTex);
        this.prevProp.SetPickable(1);
        this.middleProp.SetMapper((vtkMapper2D)mapper);
        this.middleProp.SetTexture(middleTex);
        this.middleProp.SetPickable(1);
        this.middleProp.SetWidth(pw);
        this.middleProp.SetHeight(pw);
        this.prevProp.SetWidth(pw);
        this.prevProp.SetHeight(pw);
        this.nextProp.SetWidth(pw);
        this.nextProp.SetHeight(pw);
        plusReader.GetOutputPort().Delete();
        plusReader.Delete();
        middleReader.GetOutputPort().Delete();
        middleReader.Delete();
        middleTex.Delete();
        plusTex.Delete();
        mapper.Delete();
        quad.GetPointData().Delete();
        quad.Delete();
        points.Delete();
        polygon.GetPointIds().Delete();
        polygon.Delete();
        cellArray.Delete();
        texCoords.Delete();
    }

    public PipeControlPoint.PositionType getPickedPosition(vtkProp[] picked) {
        if (picked == null) {
            return null;
        }
        vtkProp[] vtkPropArray = picked;
        int n = picked.length;
        int n2 = 0;
        while (n2 < n) {
            vtkProp p = vtkPropArray[n2];
            if (p.equals(this.middleProp)) {
                return PipeControlPoint.PositionType.SPLIT;
            }
            if (p.equals(this.nextProp)) {
                return PipeControlPoint.PositionType.NEXT;
            }
            if (p.equals(this.prevProp)) {
                return PipeControlPoint.PositionType.PREVIOUS;
            }
            ++n2;
        }
        return null;
    }
}

