/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.gizmo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.osgi.framework.Bundle;
import org.simantics.g3d.scenegraph.RenderListener;
import org.simantics.g3d.tools.PluginTools;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.g3d.vtk.gizmo.vtkGizmo;
import org.simantics.g3d.vtk.utils.vtkUtil;
import org.simantics.plant3d.Activator;
import vtk.vtkCell;
import vtk.vtkCellArray;
import vtk.vtkDataArray;
import vtk.vtkFloatArray;
import vtk.vtkMapper2D;
import vtk.vtkObjectBase;
import vtk.vtkPNGReader;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper2D;
import vtk.vtkPolygon;
import vtk.vtkProp;
import vtk.vtkRenderer;
import vtk.vtkTexture;
import vtk.vtkTexturedActor2D;

public class ConstraintPointGizmo
extends vtkGizmo {
    List<vtkTexturedActor2D> props;
    List<Vector3d> positions;
    VtkView panel;
    private RenderListener listener;
    vtkPolyDataMapper2D mapper;
    vtkTexture plusTex;
    double pw = 8.0;

    public ConstraintPointGizmo(VtkView panel) {
        this.panel = panel;
        this.props = new ArrayList<vtkTexturedActor2D>();
        this.positions = new ArrayList<Vector3d>();
        this.listener = new RenderListener(){

            public void preRender() {
                int i = 0;
                while (i < ConstraintPointGizmo.this.positions.size()) {
                    Vector3d pos = ConstraintPointGizmo.this.positions.get(i);
                    vtkTexturedActor2D prop = ConstraintPointGizmo.this.props.get(i);
                    Point2d p = vtkUtil.getScreenCoordinates((vtkRenderer)ConstraintPointGizmo.this.getRenderer(), (Tuple3d)pos);
                    prop.SetDisplayPosition((int)p.x, (int)p.y);
                    ++i;
                }
            }

            public void postRender() {
            }
        };
    }

    vtkRenderer getRenderer() {
        return this.panel.getRenderer();
    }

    public void attach(VtkView renderingPart) {
        this.panel.addListener(this.listener);
        super.attach(renderingPart);
    }

    public Collection<vtkProp> getGizmo() {
        ArrayList<vtkProp> list = new ArrayList<vtkProp>();
        for (vtkTexturedActor2D p : this.props) {
            list.add((vtkProp)p);
        }
        return list;
    }

    protected void attachActors() {
        this.panel.lock();
        vtkRenderer ren = this.getRenderer();
        while (this.props.size() < this.positions.size()) {
            this.props.add(this.createActor());
        }
        int i = 0;
        while (i < this.positions.size()) {
            vtkTexturedActor2D p = this.props.get(i);
            ren.AddActor2D((vtkProp)p);
            ++i;
        }
        this.panel.unlock();
    }

    protected void deattachActors() {
        this.panel.removeListener(this.listener);
        this.panel.lock();
        vtkRenderer ren = this.getRenderer();
        for (vtkTexturedActor2D p : this.props) {
            ren.RemoveActor2D((vtkProp)p);
        }
        this.panel.unlock();
    }

    public void addPosition(Vector3d position) {
        this.positions.add(position);
    }

    public void clearPositions() {
        this.positions.clear();
    }

    private vtkTexturedActor2D createActor() {
        if (this.mapper == null) {
            this.loadData();
        }
        vtkTexturedActor2D nextProp = new vtkTexturedActor2D();
        nextProp.SetMapper((vtkMapper2D)this.mapper);
        nextProp.SetTexture(this.plusTex);
        nextProp.SetPickable(0);
        nextProp.SetWidth(this.pw);
        nextProp.SetHeight(this.pw);
        nextProp.GetProperty().SetColor(new double[]{255.0, 0.0, 255.0});
        nextProp.GetProperty().Delete();
        this.panel.addDeletable((vtkObjectBase)nextProp);
        return nextProp;
    }

    public void dispose() {
    }

    private void loadData() {
        String plusTexFile = PluginTools.getAbsolutePath((Bundle)Activator.getDefault().getBundle(), (String)"icons/crosshair.png");
        if (plusTexFile == null) {
            throw new RuntimeException("Cannot resolve required image files.");
        }
        vtkPoints points = new vtkPoints();
        points.InsertNextPoint(-this.pw, -this.pw, 0.0);
        points.InsertNextPoint(this.pw, -this.pw, 0.0);
        points.InsertNextPoint(this.pw, this.pw, 0.0);
        points.InsertNextPoint(-this.pw, this.pw, 0.0);
        vtkCellArray cellArray = new vtkCellArray();
        vtkPolygon polygon = new vtkPolygon();
        polygon.GetPointIds().SetNumberOfIds(4);
        polygon.GetPointIds().SetId(0, 0);
        polygon.GetPointIds().SetId(1, 1);
        polygon.GetPointIds().SetId(2, 2);
        polygon.GetPointIds().SetId(3, 3);
        cellArray.InsertNextCell((vtkCell)polygon);
        vtkPolyData quad = new vtkPolyData();
        quad.SetPoints(points);
        quad.SetPolys(cellArray);
        vtkFloatArray texCoords = new vtkFloatArray();
        texCoords.SetNumberOfComponents(2);
        texCoords.InsertNextTuple2(0.0, 0.0);
        texCoords.InsertNextTuple2(1.0, 0.0);
        texCoords.InsertNextTuple2(1.0, 1.0);
        texCoords.InsertNextTuple2(0.0, 1.0);
        quad.GetPointData().SetTCoords((vtkDataArray)texCoords);
        vtkPNGReader plusReader = new vtkPNGReader();
        plusReader.SetFileName(plusTexFile);
        this.plusTex = new vtkTexture();
        this.plusTex.SetInputConnection(plusReader.GetOutputPort());
        this.plusTex.SetInterpolate(1);
        this.mapper = new vtkPolyDataMapper2D();
        this.mapper.SetInputData(quad);
        this.panel.addDeletable((vtkObjectBase)this.mapper);
        this.panel.addDeletable((vtkObjectBase)this.plusTex);
        plusReader.GetOutputPort().Delete();
        plusReader.Delete();
        quad.GetPointData().Delete();
        quad.Delete();
        points.Delete();
        polygon.GetPointIds().Delete();
        polygon.Delete();
        cellArray.Delete();
        texCoords.Delete();
    }
}

