/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.datastructures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.vecmath.Point3d;
import org.simantics.g3d.datastructures.Box;

public class OcTree<T> {
    Point3d center;
    Collection<T> contains;
    double dx;
    double dy;
    double dz;
    boolean leaf;
    OcTree<T>[] children;

    public OcTree(Point3d center, double dx, double dy, double dz, int depth) {
        if (dx <= 0.0 || dy <= 0.0 || dz <= 0.0) {
            throw new IllegalArgumentException("Size parameters cannot be negative");
        }
        if (depth < 0) {
            throw new IllegalArgumentException("Depth cannot be negative");
        }
        this.center = center;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.leaf = true;
        this.split(depth);
    }

    public OcTree(Point3d center, double dx, double dy, double dz) {
        this.center = center;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.leaf = true;
    }

    public void insert(T object, Box bounds) {
        if (this.leaf) {
            this.contains.add(object);
        } else {
            boolean[] ins = this.getAccessArr(bounds);
            int i = 0;
            while (i < 8) {
                if (ins[i]) {
                    this.children[i].insert(object, bounds);
                }
                ++i;
            }
        }
    }

    private boolean[] getAccessArr(Box bounds) {
        boolean[] ins;
        block14: {
            int i;
            boolean nZ;
            block13: {
                boolean pX = bounds.getMin().getX() > this.center.getX();
                boolean nX = bounds.getMax().getX() < this.center.getX();
                boolean pY = bounds.getMin().getY() > this.center.getY();
                boolean nY = bounds.getMax().getY() < this.center.getY();
                boolean pZ = bounds.getMin().getZ() > this.center.getZ();
                nZ = bounds.getMax().getZ() < this.center.getZ();
                ins = new boolean[8];
                i = 0;
                while (i < 8) {
                    ins[i] = true;
                    ++i;
                }
                if (pX) {
                    i = 1;
                    while (i < 8) {
                        ins[i] = false;
                        i += 2;
                    }
                } else if (nX) {
                    i = 0;
                    while (i < 8) {
                        ins[i] = false;
                        i += 2;
                    }
                }
                if (pY) {
                    i = 2;
                    while (i < 8) {
                        ins[i++] = false;
                        ins[i++] = false;
                        i += 2;
                    }
                } else if (nY) {
                    i = 0;
                    while (i < 8) {
                        ins[i++] = false;
                        ins[i++] = false;
                        i += 2;
                    }
                }
                if (!pZ) break block13;
                i = 4;
                while (i < 8) {
                    ins[i] = false;
                    ++i;
                }
                break block14;
            }
            if (!nZ) break block14;
            i = 0;
            while (i < 4) {
                ins[i] = false;
                ++i;
            }
        }
        return ins;
    }

    public void remove(T object) {
        if (this.leaf) {
            this.contains.remove(object);
        } else {
            OcTree<T>[] ocTreeArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                OcTree<T> n3 = ocTreeArray[n2];
                n3.remove(object);
                ++n2;
            }
        }
    }

    public void get(Box bounds, Set<T> set) {
        if (this.leaf) {
            set.addAll(this.contains);
        } else {
            boolean[] ins = this.getAccessArr(bounds);
            int i = 0;
            while (i < 8) {
                if (ins[i]) {
                    this.children[i].get(bounds, set);
                }
                ++i;
            }
        }
    }

    public void clear() {
        if (this.leaf) {
            this.contains.clear();
        } else {
            OcTree<T>[] ocTreeArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                OcTree<T> n3 = ocTreeArray[n2];
                n3.clear();
                ++n2;
            }
        }
    }

    private void split(int depth) {
        if (!this.leaf) {
            throw new IllegalStateException("Node is already split");
        }
        if (depth <= 0) {
            this.contains = this.createColl();
            return;
        }
        this.split();
        --depth;
        OcTree<T>[] ocTreeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            OcTree<T> n3 = ocTreeArray[n2];
            super.split(depth);
            ++n2;
        }
    }

    private void split() {
        double _dx = this.dx * 0.5;
        double _dy = this.dy * 0.5;
        double _dz = this.dz * 0.5;
        double xd2 = _dx * 0.5;
        double yd2 = _dy * 0.5;
        double zd2 = _dz * 0.5;
        this.children = new OcTree[8];
        this.children[0] = this.createChild(new Point3d(this.center.x + xd2, this.center.y + yd2, this.center.z + zd2), _dx, _dy, _dz);
        this.children[1] = this.createChild(new Point3d(this.center.x - xd2, this.center.y + yd2, this.center.z + zd2), _dx, _dy, _dz);
        this.children[2] = this.createChild(new Point3d(this.center.x + xd2, this.center.y - yd2, this.center.z + zd2), _dx, _dy, _dz);
        this.children[3] = this.createChild(new Point3d(this.center.x - xd2, this.center.y - yd2, this.center.z + zd2), _dx, _dy, _dz);
        this.children[4] = this.createChild(new Point3d(this.center.x + xd2, this.center.y + yd2, this.center.z - zd2), _dx, _dy, _dz);
        this.children[5] = this.createChild(new Point3d(this.center.x - xd2, this.center.y + yd2, this.center.z - zd2), _dx, _dy, _dz);
        this.children[6] = this.createChild(new Point3d(this.center.x + xd2, this.center.y - yd2, this.center.z - zd2), _dx, _dy, _dz);
        this.children[7] = this.createChild(new Point3d(this.center.x - xd2, this.center.y - yd2, this.center.z - zd2), _dx, _dy, _dz);
        this.leaf = false;
    }

    public void dispose() {
        if (this.leaf) {
            this.contains = null;
        } else {
            OcTree<T>[] ocTreeArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                OcTree<T> n3 = ocTreeArray[n2];
                n3.dispose();
                ++n2;
            }
            this.children = null;
        }
    }

    public void flatten(int count) {
        if (this.leaf) {
            return;
        }
        boolean allLeaf = true;
        if (!this.children[0].leaf) {
            int i = 0;
            while (i < 8) {
                this.children[i].flatten(count);
                ++i;
            }
            i = 0;
            while (i < 8) {
                if (!this.children[i].leaf) {
                    allLeaf = false;
                    break;
                }
                ++i;
            }
        } else {
            allLeaf = true;
        }
        if (allLeaf) {
            HashSet<T> coll = new HashSet<T>();
            int i = 0;
            while (i < 8) {
                coll.addAll(this.children[i].contains);
                ++i;
            }
            if (coll.size() < count) {
                this.contains = this.createColl();
                this.leaf = true;
                i = 0;
                while (i < 8) {
                    for (T o : this.children[i].contains) {
                        if (this.contains.contains(o)) continue;
                        this.contains.add(o);
                    }
                    ++i;
                }
                this.children = null;
            }
        }
    }

    protected Collection<T> createColl() {
        return new ArrayList();
    }

    protected OcTree<T> createChild(Point3d p, double dx, double dy, double dz) {
        return new OcTree<T>(p, dx, dy, dz);
    }
}

