/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.validation;

import java.util.Collections;
import java.util.List;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.issue.StandardIssue;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.issues.common.IssueUtils;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.validation.SyntaxErrorException;
import org.simantics.sysdyn.ui.validation.UndefinedExpressionException;
import org.simantics.sysdyn.ui.validation.UnsupportedCharactersException;
import org.simantics.sysdyn.ui.validation.ValidationUtils;

public class ExpressionIssueFunction {
    private static String SYNTAX_ERROR = "Syntax error";
    private static String UNSUPPORTED_CHARACTERS = "Unsupported characters";
    private static String UNDEFINED_EXPRESSION = "Undefined expression";

    @SCLValue(type="ReadGraph -> Resource -> [Issue]")
    public static List<Issue> expressionValidator(ReadGraph graph, Resource component) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        if (!graph.isInstanceOf(component, sr.IndependentVariable)) {
            return Collections.emptyList();
        }
        try {
            ValidationUtils.getAllReferences(graph, component);
        }
        catch (Exception e) {
            return Collections.singletonList(new StandardIssue(sr.Validations_ExpressionIssue, new Resource[]{component}));
        }
        return Collections.emptyList();
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String expressionIssueDescription(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        List contexts = IssueUtils.getContextsForProperty((ReadGraph)graph, (Variable)property);
        Resource component = (Resource)contexts.get(0);
        try {
            ValidationUtils.getAllReferences(graph, component);
        }
        catch (SyntaxErrorException e) {
            return SYNTAX_ERROR;
        }
        catch (UnsupportedCharactersException e) {
            return UNSUPPORTED_CHARACTERS;
        }
        catch (UndefinedExpressionException e) {
            return UNDEFINED_EXPRESSION;
        }
        return "Erroneus error";
    }
}

