/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.trend;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartColor;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.ui.Layer;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.DefaultXYDataset;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.DisposableListener;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.request.PossibleActiveExperiment;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.AbstractDataset;
import org.simantics.jfreechart.chart.IRenderer;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.operation.Layer0X;
import org.simantics.sysdyn.Functions;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.sysdyn.ui.trend.XYDatasetRequest;
import org.simantics.sysdyn.ui.trend.XYDatasetTempSeries;
import org.simantics.utils.datastructures.Pair;

public class XYDataset
extends AbstractDataset
implements org.simantics.jfreechart.chart.XYDataset {
    protected IRenderer renderer;
    protected Dataset dataset;
    protected DisposableListener<?> datasetListener;
    protected DisposableListener<Double> timeListener;

    public XYDataset(ReadGraph graph, Resource datasetResource) throws DatabaseException {
        super(datasetResource);
    }

    protected DisposableListener<Double> getTimeListener() {
        if (this.timeListener == null || this.timeListener.isDisposed()) {
            this.timeListener = new TimeListener();
        }
        return this.timeListener;
    }

    protected Read<Double> getTimeRequest() {
        return new Read<Double>(){

            public Double perform(ReadGraph graph) throws DatabaseException {
                List seriesList;
                JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                Resource series = graph.getPossibleObject(XYDataset.this.resource, jfree.Dataset_seriesList);
                if (series != null && (seriesList = ListUtils.toList((ReadGraph)graph, (Resource)series)) != null) {
                    String realizationURI = XYDataset.getRealizationURI(graph, XYDataset.this.resource);
                    for (Resource r : seriesList) {
                        Variable v;
                        block5: {
                            String rvi = (String)graph.getPossibleRelatedValue(r, jfree.variableRVI);
                            if (rvi == null) continue;
                            v = Variables.getVariable((ReadGraph)graph, (String)realizationURI);
                            if (v != null) break block5;
                            return null;
                        }
                        try {
                            Variable timeVar = v.browsePossible(graph, "#" + Functions.TIME);
                            if (timeVar == null) continue;
                            return (Double)timeVar.getValue(graph, (Binding)Bindings.DOUBLE);
                        }
                        catch (MissingVariableException missingVariableException) {
                            // empty catch block
                        }
                    }
                }
                return null;
            }
        };
    }

    public Dataset getDataset() {
        if (this.dataset == null) {
            this.dataset = new DefaultXYDataset();
        }
        if (this.datasetListener == null || this.datasetListener.isDisposed()) {
            this.datasetListener = new DataSetListener();
            Simantics.getSession().asyncRequest((Read)new XYDatasetRequest(this.resource), this.datasetListener);
        }
        if (this.timeListener == null || this.timeListener.isDisposed()) {
            Simantics.getSession().asyncRequest(this.getTimeRequest(), this.getTimeListener());
        }
        return this.dataset;
    }

    public void dispose() {
        if (this.timeListener != null) {
            this.timeListener.dispose();
            this.timeListener = null;
        }
        if (this.datasetListener != null) {
            this.datasetListener.dispose();
            this.datasetListener = null;
        }
    }

    public AbstractRenderer getRenderer() {
        if (this.renderer == null) {
            try {
                this.renderer = (IRenderer)Simantics.getSession().syncRequest((Read)new Read<IRenderer>(){

                    public IRenderer perform(ReadGraph graph) throws DatabaseException {
                        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                        IRenderer renderer = null;
                        Resource rendererResource = graph.getPossibleObject(XYDataset.this.resource, jfree.Dataset_renderer);
                        if (rendererResource != null) {
                            renderer = (IRenderer)graph.adapt(rendererResource, IRenderer.class);
                        }
                        return renderer;
                    }
                });
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
            if (this.renderer == null) {
                XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
                renderer.setDefaultToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
                return renderer;
            }
            return this.renderer.getRenderer();
        }
        return this.renderer.getRenderer();
    }

    public static String getRealizationURI(ReadGraph graph, Resource resource) throws DatabaseException {
        if (resource == null) {
            return null;
        }
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
        Resource model = resource;
        while ((model = graph.getPossibleObject(model, l0.PartOf)) != null && !graph.isInstanceOf(model, mr.StructuralModel)) {
        }
        if (model == null) {
            return null;
        }
        String realizationURI = null;
        Resource realization = (Resource)graph.syncRequest((Read)new PossibleActiveExperiment(model));
        if (realization == null) {
            Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
            realization = graph.getPossibleObject(model, L0X.HasBaseRealization);
        }
        if (realization != null) {
            realizationURI = graph.getURI(realization);
        }
        return realizationURI;
    }

    private class DataSetListener
    extends DisposableListener<Pair<ArrayList<XYDatasetTempSeries>, IRenderer>> {
        private DataSetListener() {
        }

        public void execute(Pair<ArrayList<XYDatasetTempSeries>, IRenderer> result) {
            final ArrayList series = (ArrayList)result.first;
            XYDataset.this.renderer = (IRenderer)result.second;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (((DataSetListener)DataSetListener.this).XYDataset.this.dataset == null || !(((DataSetListener)DataSetListener.this).XYDataset.this.dataset instanceof DefaultXYDataset)) {
                        return;
                    }
                    DefaultXYDataset ds = (DefaultXYDataset)((DataSetListener)DataSetListener.this).XYDataset.this.dataset;
                    XYPlot plot = ((AbstractXYItemRenderer)XYDataset.this.getRenderer()).getPlot();
                    if (plot != null) {
                        Paint[] paintSequence = ChartColor.createDefaultPaintArray();
                        paintSequence[3] = new Color(255, 221, 0);
                        DefaultDrawingSupplier drawingsupplier = new DefaultDrawingSupplier(paintSequence, DefaultDrawingSupplier.DEFAULT_FILL_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE);
                        plot.setDrawingSupplier((DrawingSupplier)drawingsupplier);
                    }
                    int i = ds.getSeriesCount() - 1;
                    while (i >= 0) {
                        ds.removeSeries(ds.getSeriesKey(i));
                        --i;
                    }
                    i = 0;
                    while (i < series.size()) {
                        XYDatasetTempSeries s = (XYDatasetTempSeries)series.get(i);
                        String name = s.name;
                        if (ds.indexOf((Comparable)((Object)name)) >= 0) {
                            name = String.valueOf(name) + (i + 1);
                        }
                        ds.addSeries((Comparable)((Object)name), s.values);
                        XYDataset.this.getRenderer().setSeriesStroke(i, (Stroke)new BasicStroke(s.width));
                        XYDataset.this.getRenderer().setSeriesPaint(i, (Paint)s.color);
                        ++i;
                    }
                }
            });
        }

        public void exception(Throwable t) {
            t.printStackTrace();
        }
    }

    protected class TimeListener
    extends DisposableListener<Double> {
        private ValueMarker marker;
        private Stroke dashStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f, 3.0f, 1.0f, 3.0f}, 0.0f);

        public TimeListener() {
            this.marker = new TimeMarker(0.0, Color.red, this.dashStroke);
        }

        public void dispose() {
            XYPlot plot;
            super.dispose();
            if (this.marker != null && (plot = ((AbstractXYItemRenderer)XYDataset.this.getRenderer()).getPlot()) != null) {
                plot.removeDomainMarker((Marker)this.marker);
            }
        }

        public void execute(final Double time) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    XYPlot plot = ((AbstractXYItemRenderer)XYDataset.this.getRenderer()).getPlot();
                    if (plot == null) {
                        return;
                    }
                    plot.removeDomainMarker((Marker)TimeListener.this.marker);
                    if (time != null) {
                        TimeListener.this.marker.setValue(time.doubleValue());
                        if (plot.getDomainMarkers(Layer.FOREGROUND) == null || !plot.getDomainMarkers(Layer.FOREGROUND).contains(TimeListener.this.marker)) {
                            int i = 0;
                            i = 0;
                            while (i < plot.getDatasetCount()) {
                                if (plot.getDataset(i) != null && plot.getDataset(i).equals(((TimeListener)TimeListener.this).XYDataset.this.dataset)) break;
                                ++i;
                            }
                            plot.addDomainMarker(i, (Marker)TimeListener.this.marker, Layer.FOREGROUND);
                        }
                    }
                }
            });
        }

        public void exception(Throwable t) {
            t.printStackTrace();
        }
    }

    protected class TimeMarker
    extends ValueMarker {
        private static final long serialVersionUID = 2018755066561629172L;

        public TimeMarker(double value, Paint paint, Stroke stroke) {
            super(value, paint, stroke);
        }
    }
}

